/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.Optional;
import lombok.NonNull;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.std.SerializerMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInputWithMapper
implements ObjectInput {
    private static final Logger log = LoggerFactory.getLogger(ObjectInputWithMapper.class);
    private final ObjectInput in;
    private final SerializerMapper mapper;

    public ObjectInputWithMapper(@NonNull ObjectInput in, @NonNull SerializerMapper mapper) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        this.in = in;
        this.mapper = mapper;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        Object object = this.in.readObject();
        if (object instanceof Class) {
            Class type = (Class)object;
            Optional<Serializer<Object>> optSerializer = this.mapper.getSerializer(type);
            if (!optSerializer.isPresent()) {
                optSerializer = this.mapper.getSerializer(type.getName());
            }
            Serializer serializer = optSerializer.orElseGet(() -> {
                log.warn("No serializer found for class {} in {}", (Object)type.getName(), (Object)this.mapper);
                return this.mapper.getDefaultSerializer();
            });
            return serializer.read(this);
        }
        return object;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.in.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.in.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.in.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }
}

