/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.serializer.std;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bsc.langgraph4j.serializer.Serializer;
import org.bsc.langgraph4j.serializer.std.ObjectInputWithMapper;
import org.bsc.langgraph4j.serializer.std.ObjectOutputWithMapper;

public class SerializerMapper {
    static final Serializer<Object> DEFAULT_SERIALIZER = new Serializer<Object>(){

        @Override
        public void write(Object object, ObjectOutput out) throws IOException {
            out.writeObject(object);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readObject();
        }
    };
    private final Map<Key, Serializer<?>> _serializers = new HashMap();

    public SerializerMapper register(@NonNull Class<?> clazz, @NonNull Serializer<?> serializer) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        this._serializers.put(Key.of(clazz), serializer);
        return this;
    }

    public boolean unregister(@NonNull Class<? extends Serializer<?>> clazz) {
        Objects.requireNonNull(clazz, "Serializer's class cannot be null");
        Serializer<?> serializer = this._serializers.remove(Key.of(clazz));
        return serializer != null;
    }

    public Optional<Serializer<Object>> getSerializer(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Serializer<?> ser = this._serializers.get(Key.of(clazz));
        return ser != null ? Optional.of(ser) : this._serializers.entrySet().stream().filter(e -> ((Key)e.getKey()).getType().isAssignableFrom(clazz)).findFirst().map(e -> (Serializer)e.getValue());
    }

    public Optional<Serializer<Object>> getSerializer(@NonNull String className) {
        if (className == null) {
            throw new NullPointerException("className is marked non-null but is null");
        }
        return Optional.ofNullable(this._serializers.get(Key.of(className)));
    }

    public Serializer<Object> getDefaultSerializer() {
        return DEFAULT_SERIALIZER;
    }

    protected final ObjectOutput objectOutputWithMapper(@NonNull ObjectOutput out) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        ObjectOutputWithMapper mapperOut = out instanceof ObjectOutputWithMapper ? (ObjectOutputWithMapper)out : new ObjectOutputWithMapper(out, this);
        return mapperOut;
    }

    protected final ObjectInput objectInputWithMapper(@NonNull ObjectInput in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        ObjectInputWithMapper mapperIn = in instanceof ObjectInputWithMapper ? (ObjectInputWithMapper)in : new ObjectInputWithMapper(in, this);
        return mapperIn;
    }

    public String toString() {
        List typeNames = this._serializers.keySet().stream().map(Key::getTypeName).collect(Collectors.toList());
        return String.format("SerializerMapper: \n%s", String.join((CharSequence)"\n", typeNames));
    }

    static class Key {
        private final String _className;
        private final Class<?> _clazz;

        public static Key of(Class<?> clazz) {
            return new Key(clazz);
        }

        public static Key of(String className) {
            return new Key(className);
        }

        private Key(Class<?> clazz) {
            this._className = clazz.getName();
            this._clazz = clazz;
        }

        private Key(String className) {
            this._className = className;
            this._clazz = null;
        }

        String getTypeName() {
            return this._className;
        }

        Class<?> getType() {
            return this._clazz;
        }

        public boolean equals(Object o) {
            return Objects.equals(o, this._className);
        }

        public int hashCode() {
            return Objects.hash(this._className);
        }
    }
}

