/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bsc.langgraph4j.state.AppendableValue;
import org.bsc.langgraph4j.state.AppendableValueRW;
import org.bsc.langgraph4j.state.Channel;

public class AgentState {
    private final Map<String, Object> data;

    public AgentState(Map<String, Object> initData) {
        this.data = new HashMap<String, Object>(initData);
    }

    public final Map<String, Object> data() {
        return Collections.unmodifiableMap(this.data);
    }

    public final <T> Optional<T> value(String key) {
        return Optional.ofNullable(this.data().get(key));
    }

    public final <T> T value(String key, T defaultValue) {
        return this.value(key).orElse(defaultValue);
    }

    public final <T> T value(String key, Supplier<T> defaultProvider) {
        return this.value(key).orElseGet(defaultProvider);
    }

    @Deprecated
    public final <T> AppendableValue<T> appendableValue(String key) {
        Object value = this.data.get(key);
        if (value instanceof AppendableValue) {
            return (AppendableValue)value;
        }
        if (value instanceof Collection) {
            return new AppendableValueRW((Collection)value);
        }
        AppendableValueRW rw = new AppendableValueRW();
        if (value != null) {
            rw.append(value);
        }
        this.data.put(key, rw);
        return rw;
    }

    @Deprecated
    public final Map<String, Object> mergeWith(Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        return AgentState.updateState(this.data(), partialState, channels);
    }

    public String toString() {
        return this.data.toString();
    }

    private static Object mergeFunction(Object currentValue, Object newValue) {
        if (currentValue instanceof AppendableValueRW) {
            ((AppendableValueRW)currentValue).append(newValue);
            return currentValue;
        }
        return newValue;
    }

    private static Map<String, Object> updatePartialStateFromSchema(Map<String, Object> state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        if (channels == null || channels.isEmpty()) {
            return partialState;
        }
        return partialState.entrySet().stream().map(entry -> {
            Channel channel = (Channel)channels.get(entry.getKey());
            if (channel != null) {
                Object newValue = channel.update((String)entry.getKey(), state.get(entry.getKey()), entry.getValue());
                return new AbstractMap.SimpleImmutableEntry<String, Object>((String)entry.getKey(), newValue);
            }
            return entry;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, Object> updateState(Map<String, Object> state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        Objects.requireNonNull(state, "state cannot be null");
        if (partialState == null || partialState.isEmpty()) {
            return state;
        }
        Map<String, Object> updatedPartialState = AgentState.updatePartialStateFromSchema(state, partialState, channels);
        return Stream.concat(state.entrySet().stream(), updatedPartialState.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, AgentState::mergeFunction));
    }

    public static Map<String, Object> updateState(AgentState state, Map<String, Object> partialState, Map<String, Channel<?>> channels) {
        return AgentState.updateState(state.data(), partialState, channels);
    }
}

