/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.bsc.langgraph4j.state.Channel;
import org.bsc.langgraph4j.state.Reducer;
import org.bsc.langgraph4j.utils.CollectionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppenderChannel<T>
implements Channel<List<T>> {
    private static final Logger log = LoggerFactory.getLogger(AppenderChannel.class);
    private final Reducer<List<T>> reducer = new Reducer<List<T>>(){

        @Override
        public List<T> apply(List<T> left, List<T> right) {
            if (left == null) {
                return right;
            }
            left.addAll(right);
            return left;
        }
    };
    private final Supplier<List<T>> defaultProvider;

    @Override
    public Optional<Reducer<List<T>>> getReducer() {
        return Optional.ofNullable(this.reducer);
    }

    @Override
    public Optional<Supplier<List<T>>> getDefault() {
        return Optional.ofNullable(this.defaultProvider);
    }

    public static <T> AppenderChannel<T> of(Supplier<List<T>> defaultProvider) {
        return new AppenderChannel<T>(defaultProvider);
    }

    private AppenderChannel(Supplier<List<T>> defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    public Object update(String key, Object oldValue, Object newValue) {
        if (newValue == null) {
            return oldValue;
        }
        try {
            List<Object> list = null;
            if (newValue instanceof List) {
                list = (List<Object>)newValue;
            } else if (newValue.getClass().isArray()) {
                list = Arrays.asList((Object[])newValue);
            }
            if (list != null) {
                if (list.isEmpty()) {
                    return oldValue;
                }
                return Channel.super.update(key, oldValue, list);
            }
            try {
                Object typedValue = newValue;
                return Channel.super.update(key, oldValue, CollectionsUtils.listOf(typedValue));
            }
            catch (ClassCastException e) {
                log.error("Unsupported content type: {}", newValue.getClass());
                throw e;
            }
        }
        catch (UnsupportedOperationException ex) {
            log.error("Unsupported operation: probably because the appendable channel has been initialized with a immutable List. Check please !");
            throw ex;
        }
    }
}

