/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import java.util.Optional;
import java.util.function.Supplier;
import org.bsc.langgraph4j.state.BaseChannel;
import org.bsc.langgraph4j.state.Reducer;

public interface Channel<T> {
    public static <T> Channel<T> of(Supplier<T> defaultProvider) {
        return new BaseChannel<T>(null, defaultProvider);
    }

    public static <T> Channel<T> of(Reducer<T> reducer) {
        return new BaseChannel<T>(reducer, null);
    }

    public static <T> Channel<T> of(Reducer<T> reducer, Supplier<T> defaultProvider) {
        return new BaseChannel<T>(reducer, defaultProvider);
    }

    public Optional<Reducer<T>> getReducer();

    public Optional<Supplier<T>> getDefault();

    default public Object update(String key, Object oldValue, Object newValue) {
        Object _new = newValue;
        Object _old = oldValue == null ? this.getDefault().map(Supplier::get).orElse(null) : oldValue;
        return this.getReducer().map(reducer -> reducer.apply(_old, _new)).orElse(_new);
    }
}

