/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.state;

import lombok.NonNull;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.checkpoint.Checkpoint;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AgentStateFactory;

public final class StateSnapshot<State extends AgentState>
extends NodeOutput<State> {
    private final RunnableConfig config;

    public String next() {
        return this.config.nextNode().orElse(null);
    }

    public RunnableConfig config() {
        return this.config;
    }

    @Deprecated
    public RunnableConfig getConfig() {
        return this.config();
    }

    @Deprecated
    public String getNext() {
        return this.next();
    }

    private StateSnapshot(@NonNull String node, @NonNull State state, @NonNull RunnableConfig config) {
        super(node, state);
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
    }

    @Override
    public String toString() {
        return String.format("StateSnapshot{node=%s, state=%s, config=%s}", this.node(), this.state(), this.config());
    }

    public static <State extends AgentState> StateSnapshot<State> of(Checkpoint checkpoint, RunnableConfig config, AgentStateFactory<State> factory) {
        RunnableConfig newConfig = RunnableConfig.builder(config).checkPointId(checkpoint.getId()).nextNode(checkpoint.getNextNodeId()).build();
        return new StateSnapshot<AgentState>(checkpoint.getNodeId(), (AgentState)factory.apply(checkpoint.getState()), newConfig);
    }
}

