package org.bsc.langgraph4j.state;

import java.util.*;

import static java.util.Collections.unmodifiableList;

/**
 * Represents a value that can be appended to and provides various utility methods.
 *
 * @param <T> the type of the value
 */
@Deprecated
public interface AppendableValue<T> {

    /**
     * Returns the list of values.
     *
     * @return a list of values
     */
    List<T> values();

    /**
     * Checks if the value list is empty.
     *
     * @return true if the value list is empty, false otherwise
     */
    boolean isEmpty();

    /**
     * Returns the size of the value list.
     *
     * @return the size of the value list
     */
    int size();

    /**
     * Returns the last value in the list, if present.
     *
     * @return an Optional containing the last value if present, otherwise an empty Optional
     */
    Optional<T> last();

    /**
     * Returns the value at the specified position from the end of the list, if present.
     *
     * @param n the position from the end of the list
     * @return an Optional containing the value at the specified position if present, otherwise an empty Optional
     */
    Optional<T> lastMinus(int n);
}
