/**
 * Provides classes and interfaces for managing the state of agents in the langgraph4j framework.
 * <p>
 * This package includes:
 * <ul>
 *   <li>{@link org.bsc.langgraph4j.state.AgentState} - Represents the state of an agent with a map of data.</li>
 *   <li>{@link org.bsc.langgraph4j.state.AgentStateFactory} - A factory interface for creating instances of {@link org.bsc.langgraph4j.state.AgentState}.</li>
 *   <li>{@link org.bsc.langgraph4j.state.AppendableValue} - Represents a value that can be appended to and provides various utility methods.</li>
 *   <li>{@link org.bsc.langgraph4j.state.AppendableValueRW} - A class that implements the {@link org.bsc.langgraph4j.state.AppendableValue} interface and provides functionality to append values to a list and retrieve various properties of the list.</li>
 * </ul>
 */
package org.bsc.langgraph4j.state;