/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.image_to_diagram;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.image_to_diagram.ImageToDiagram;
import dev.langchain4j.image_to_diagram.PlantUMLAction;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.Response;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.bsc.async.AsyncGenerator;
import org.bsc.langgraph4j.CompiledGraph;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncEdgeAction;
import org.bsc.langgraph4j.utils.CollectionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramCorrectionProcess
implements ImageToDiagram {
    private static final Logger log = LoggerFactory.getLogger((String)"DiagramCorrectionProcess");
    private final AtomicReference<Object> LLM = new AtomicReference();

    private OpenAiChatModel newLLM() {
        String openApiKey = Optional.ofNullable(System.getProperty("OPENAI_API_KEY")).orElseThrow(() -> new IllegalArgumentException("no OPENAI_API_KEY provided!"));
        return OpenAiChatModel.builder().apiKey(openApiKey).modelName("gpt-3.5-turbo").logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
    }

    CompletableFuture<Map<String, Object>> reviewResult(ImageToDiagram.State state) {
        CompletableFuture<Map<String, Object>> future = new CompletableFuture<Map<String, Object>>();
        try {
            String diagramCode = (String)CollectionsUtils.last(state.diagramCode()).orElseThrow(() -> new IllegalArgumentException("no diagram code provided!"));
            String error = state.evaluationError().orElseThrow(() -> new IllegalArgumentException("no evaluation error provided!"));
            log.trace("evaluation error: {}", (Object)error);
            Prompt systemPrompt = this.loadPromptTemplate("review_diagram.txt").apply(CollectionsUtils.mapOf((Object)"evaluationError", (Object)error, (Object)"diagramCode", (Object)diagramCode));
            Response response = this.getLLM().generate(new ChatMessage[]{new SystemMessage(systemPrompt.text())});
            String result = ((AiMessage)response.content()).text();
            log.trace("review result: {}", (Object)result);
            future.complete(CollectionsUtils.mapOf((Object)"diagramCode", (Object)result));
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private CompletableFuture<Map<String, Object>> evaluateResult(ImageToDiagram.State state) {
        String diagramCode = (String)CollectionsUtils.last(state.diagramCode()).orElseThrow(() -> new IllegalArgumentException("no diagram code provided!"));
        return ((CompletableFuture)PlantUMLAction.validate(diagramCode).thenApply(v -> CollectionsUtils.mapOf((Object)"evaluationResult", (Object)((Object)ImageToDiagram.EvaluationResult.OK)))).exceptionally(e -> {
            if (e.getCause() instanceof PlantUMLAction.Error) {
                return CollectionsUtils.mapOf((Object)"evaluationResult", (Object)((Object)ImageToDiagram.EvaluationResult.ERROR), (Object)"evaluationError", (Object)e.getCause().getMessage(), (Object)"evaluationErrorType", (Object)((PlantUMLAction.Error)e.getCause()).getType());
            }
            throw new RuntimeException((Throwable)e);
        });
    }

    private String routeEvaluationResult(ImageToDiagram.State state) {
        ImageToDiagram.EvaluationResult evaluationResult = state.evaluationResult().orElseThrow(() -> new IllegalArgumentException("no evaluationResult provided!"));
        if (evaluationResult == ImageToDiagram.EvaluationResult.ERROR) {
            if (state.isExecutionError()) {
                log.warn("evaluation execution error: [{}]", (Object)state.evaluationError().orElse("unknown"));
                return ImageToDiagram.EvaluationResult.UNKNOWN.name();
            }
            if (state.lastTwoDiagramsAreEqual()) {
                log.warn("correction failed! ");
                return ImageToDiagram.EvaluationResult.UNKNOWN.name();
            }
        }
        return evaluationResult.name();
    }

    @Override
    public AsyncGenerator<NodeOutput<ImageToDiagram.State>> execute(Map<String, Object> inputs) throws Exception {
        StateGraph workflow = new StateGraph(ImageToDiagram.State::new);
        workflow.addNode("evaluate_result", this::evaluateResult);
        workflow.addNode("agent_review", this::reviewResult);
        workflow.addEdge("agent_review", "evaluate_result");
        workflow.addConditionalEdges("evaluate_result", AsyncEdgeAction.edge_async(this::routeEvaluationResult), CollectionsUtils.mapOf((Object)"OK", (Object)StateGraph.END, (Object)"ERROR", (Object)"agent_review", (Object)"UNKNOWN", (Object)StateGraph.END));
        workflow.addEdge(StateGraph.START, "evaluate_result");
        CompiledGraph app = workflow.compile();
        return app.stream(inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenAiChatModel getLLM() {
        Object $value = this.LLM.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.LLM;
            synchronized (atomicReference) {
                $value = this.LLM.get();
                if ($value == null) {
                    OpenAiChatModel actualValue = this.newLLM();
                    $value = actualValue == null ? this.LLM : actualValue;
                    this.LLM.set($value);
                }
            }
        }
        return (OpenAiChatModel)($value == this.LLM ? null : $value);
    }
}

