/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.image_to_diagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Objects;

public class ImageLoader {
    public static String loadImageAsBase64(String resourcePath) throws IOException {
        try (InputStream inputStream = ImageLoader.class.getClassLoader().getResourceAsStream(resourcePath);){
            String string = ImageLoader.loadImageAsBase64(inputStream);
            return string;
        }
    }

    public static String loadImageAsBase64(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[4096];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] imageBytes = buffer.toByteArray();
            String string = Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
    }
}

