/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.image_to_diagram;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.image_to_diagram.Diagram;
import dev.langchain4j.image_to_diagram.DiagramCorrectionProcess;
import dev.langchain4j.image_to_diagram.DiagramOutputParser;
import dev.langchain4j.image_to_diagram.ImageLoader;
import dev.langchain4j.image_to_diagram.ImageToDiagram;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.output.Response;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.bsc.async.AsyncGenerator;
import org.bsc.langgraph4j.CompiledGraph;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncEdgeAction;
import org.bsc.langgraph4j.action.AsyncNodeAction;
import org.bsc.langgraph4j.utils.CollectionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageToDiagramProcess
implements ImageToDiagram {
    private static final Logger log = LoggerFactory.getLogger((String)"ImageToDiagramProcess");
    private final ImageUrlOrData imageUrlOrData;
    private final AtomicReference<Object> LLM = new AtomicReference();

    public ImageToDiagramProcess(URI image) {
        this.imageUrlOrData = ImageUrlOrData.of(image);
    }

    public ImageToDiagramProcess(String resourceName) throws Exception {
        String imageData = ImageLoader.loadImageAsBase64(resourceName);
        this.imageUrlOrData = ImageUrlOrData.of(imageData);
    }

    private String routeDiagramTranslation(ImageToDiagram.State state) {
        return state.diagram().filter(d -> d.type.equalsIgnoreCase("sequence")).map(d -> "sequence").orElse("generic");
    }

    private Map<String, Object> describeDiagramImage(ChatLanguageModel visionModel, ImageUrlOrData imageUrlOrData, ImageToDiagram.State state) throws Exception {
        Prompt systemPrompt = this.loadPromptTemplate("describe_diagram_image.txt").apply(CollectionsUtils.mapOf());
        ImageContent imageContent = imageUrlOrData.url() != null ? ImageContent.from((URI)imageUrlOrData.url(), (ImageContent.DetailLevel)ImageContent.DetailLevel.AUTO) : ImageContent.from((String)imageUrlOrData.data(), (String)"image/png", (ImageContent.DetailLevel)ImageContent.DetailLevel.AUTO);
        TextContent textContent = new TextContent(systemPrompt.text());
        UserMessage message = UserMessage.from((Content[])new Content[]{textContent, imageContent});
        Response response = visionModel.generate(new ChatMessage[]{message});
        DiagramOutputParser outputParser = new DiagramOutputParser();
        Diagram.Element result = outputParser.parse(((AiMessage)response.content()).text());
        return CollectionsUtils.mapOf((Object)"diagram", (Object)result);
    }

    private Map<String, Object> translateGenericDiagramDescriptionToPlantUML(ImageToDiagram.State state) throws Exception {
        Diagram.Element diagram = state.diagram().orElseThrow(() -> new IllegalArgumentException("no diagram provided!"));
        Prompt systemPrompt = this.loadPromptTemplate("convert_generic_diagram_to_plantuml.txt").apply(CollectionsUtils.mapOf((Object)"diagram_description", (Object)diagram));
        Response response = this.getLLM().generate(new ChatMessage[]{new SystemMessage(systemPrompt.text())});
        String result = ((AiMessage)response.content()).text();
        return CollectionsUtils.mapOf((Object)"diagramCode", (Object)result);
    }

    private Map<String, Object> translateSequenceDiagramDescriptionToPlantUML(ImageToDiagram.State state) throws Exception {
        Diagram.Element diagram = state.diagram().orElseThrow(() -> new IllegalArgumentException("no diagram provided!"));
        Prompt systemPrompt = this.loadPromptTemplate("convert_sequence_diagram_to_plantuml.txt").apply(CollectionsUtils.mapOf((Object)"diagram_description", (Object)diagram));
        Response response = this.getLLM().generate(new ChatMessage[]{new SystemMessage(systemPrompt.text())});
        String result = ((AiMessage)response.content()).text();
        return CollectionsUtils.mapOf((Object)"diagramCode", (Object)result);
    }

    private OpenAiChatModel newLLM() {
        String openApiKey = Optional.ofNullable(System.getProperty("OPENAI_API_KEY")).orElseThrow(() -> new IllegalArgumentException("no OPENAI_API_KEY provided!"));
        return OpenAiChatModel.builder().apiKey(openApiKey).modelName("gpt-3.5-turbo").logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
    }

    private CompletableFuture<Map<String, Object>> evaluateResult(ImageToDiagram.State state) {
        CompletableFuture<Map<String, Object>> result = new CompletableFuture<Map<String, Object>>();
        DiagramCorrectionProcess diagramCorrectionProcess = new DiagramCorrectionProcess();
        ArrayList list = new ArrayList();
        try {
            return diagramCorrectionProcess.execute(state.data()).collectAsync(list, v -> log.info(v.toString())).thenApply(v -> {
                if (list.isEmpty()) {
                    throw new RuntimeException("no results");
                }
                NodeOutput last = (NodeOutput)list.get(list.size() - 1);
                return ((ImageToDiagram.State)last.state()).data();
            });
        }
        catch (Exception e) {
            result.completeExceptionally(e);
            return result;
        }
    }

    @Override
    public AsyncGenerator<NodeOutput<ImageToDiagram.State>> execute(Map<String, Object> inputs) throws Exception {
        String openApiKey = Optional.ofNullable(System.getProperty("OPENAI_API_KEY")).orElseThrow(() -> new IllegalArgumentException("no OPENAI_API_KEY provided!"));
        OpenAiChatModel llmVision = OpenAiChatModel.builder().apiKey(openApiKey).modelName("gpt-4-vision-preview").timeout(Duration.ofMinutes(2L)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).maxRetries(Integer.valueOf(2)).temperature(Double.valueOf(0.0)).maxTokens(Integer.valueOf(2000)).build();
        CompiledGraph app = new StateGraph(ImageToDiagram.State::new).addNode("agent_describer", AsyncNodeAction.node_async(state -> this.describeDiagramImage((ChatLanguageModel)llmVision, this.imageUrlOrData, (ImageToDiagram.State)state))).addNode("agent_sequence_plantuml", AsyncNodeAction.node_async(this::translateSequenceDiagramDescriptionToPlantUML)).addNode("agent_generic_plantuml", AsyncNodeAction.node_async(this::translateGenericDiagramDescriptionToPlantUML)).addConditionalEdges("agent_describer", AsyncEdgeAction.edge_async(this::routeDiagramTranslation), CollectionsUtils.mapOf((Object)"sequence", (Object)"agent_sequence_plantuml", (Object)"generic", (Object)"agent_generic_plantuml")).addNode("evaluate_result", this::evaluateResult).addEdge("agent_sequence_plantuml", "evaluate_result").addEdge("agent_generic_plantuml", "evaluate_result").addEdge(StateGraph.START, "agent_describer").addEdge("evaluate_result", StateGraph.END).compile();
        return app.stream(inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenAiChatModel getLLM() {
        Object $value = this.LLM.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.LLM;
            synchronized (atomicReference) {
                $value = this.LLM.get();
                if ($value == null) {
                    OpenAiChatModel actualValue = this.newLLM();
                    $value = actualValue == null ? this.LLM : actualValue;
                    this.LLM.set($value);
                }
            }
        }
        return (OpenAiChatModel)($value == this.LLM ? null : $value);
    }

    public static final class ImageUrlOrData {
        private final URI url;
        private final String data;

        public static ImageUrlOrData of(URI url) {
            Objects.requireNonNull(url);
            return new ImageUrlOrData(url, null);
        }

        public static ImageUrlOrData of(String data) {
            Objects.requireNonNull(data);
            return new ImageUrlOrData(null, data);
        }

        public ImageUrlOrData(URI url, String data) {
            this.url = url;
            this.data = data;
        }

        public URI url() {
            return this.url;
        }

        public String data() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageUrlOrData)) {
                return false;
            }
            ImageUrlOrData other = (ImageUrlOrData)o;
            URI this$url = this.url();
            URI other$url = other.url();
            if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $url = this.url();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ImageToDiagramProcess.ImageUrlOrData(url=" + this.url() + ", data=" + this.data() + ")";
        }
    }
}

