/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.image_to_diagram;

import dev.langchain4j.image_to_diagram.Diagram;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.model.openai.OpenAiChatModel;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sourceforge.plantuml.ErrorUmlType;
import org.bsc.async.AsyncGenerator;
import org.bsc.langgraph4j.NodeOutput;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.state.AppenderChannel;
import org.bsc.langgraph4j.state.Channel;
import org.bsc.langgraph4j.utils.CollectionsUtils;

public interface ImageToDiagram {
    public OpenAiChatModel getLLM();

    default public PromptTemplate loadPromptTemplate(String resourceName) throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new IllegalArgumentException("File not found: " + resourceName);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 4096);){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line).append('\n');
            }
            PromptTemplate promptTemplate = PromptTemplate.from((String)result.toString());
            return promptTemplate;
        }
    }

    public AsyncGenerator<NodeOutput<State>> execute(Map<String, Object> var1) throws Exception;

    public static enum EvaluationResult {
        OK,
        ERROR,
        UNKNOWN;

    }

    public static class State
    extends AgentState {
        static Map<String, Channel<?>> SCHEMA = CollectionsUtils.mapOf((Object)"messages", (Object)AppenderChannel.of(ArrayList::new));

        public State(Map<String, Object> initData) {
            super(initData);
        }

        public Optional<Diagram.Element> diagram() {
            return this.value("diagram");
        }

        public List<String> diagramCode() {
            return this.value("diagramCode").orElseGet(Collections::emptyList);
        }

        public Optional<EvaluationResult> evaluationResult() {
            return this.value("evaluationResult");
        }

        public Optional<String> evaluationError() {
            return this.value("evaluationError");
        }

        public Optional<ErrorUmlType> evaluationErrorType() {
            return this.value("evaluationErrorType");
        }

        public boolean isExecutionError() {
            return this.evaluationErrorType().map(type -> type == ErrorUmlType.EXECUTION_ERROR).orElse(false);
        }

        public boolean lastTwoDiagramsAreEqual() {
            if (this.diagramCode().size() < 2) {
                return false;
            }
            String last = CollectionsUtils.last(this.diagramCode()).map(String::trim).orElseThrow(() -> new IllegalStateException("last() is null!"));
            String prev = CollectionsUtils.lastMinus(this.diagramCode(), (int)1).map(String::trim).orElseThrow(() -> new IllegalStateException("last(-1) is null!"));
            return last.equals(prev);
        }
    }
}

