/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.multi_agent.springai;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bsc.langgraph4j.CompiledGraph;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.multi_agent.springai.AbstractAgent;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.spring.ai.agentexecutor.AgentExecutor;
import org.springframework.ai.chat.messages.AbstractMessage;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;

public abstract class AbstractAgentExecutor<B extends AbstractAgent.Builder<B>>
extends AbstractAgent<Request, String, B> {
    final CompiledGraph<AgentExecutor.State> agentExecutor;

    protected AbstractAgentExecutor(Builder<B> builder) throws GraphStateException {
        super(builder.inputType((Type)((Object)Request.class)));
        this.agentExecutor = builder.agentExecutorBuilder.build().compile();
    }

    @Override
    public String apply(Request request, ToolContext toolContext) {
        UserMessage userMessage = new UserMessage(request.input());
        Optional result = this.agentExecutor.invoke(Map.of("messages", userMessage));
        return result.flatMap(MessagesState::lastMessage).map(AssistantMessage.class::cast).map(AbstractMessage::getText).orElseThrow();
    }

    public record Request(String input) {
    }

    public static abstract class Builder<B extends AbstractAgent.Builder<B>>
    extends AbstractAgent.Builder<B> {
        final AgentExecutor.Builder agentExecutorBuilder = new AgentExecutor.Builder();

        public B chatModel(ChatModel chatModel) {
            this.agentExecutorBuilder.chatModel(chatModel);
            return this.result();
        }

        public B tool(ToolCallback tool) {
            this.agentExecutorBuilder.tool(tool);
            return this.result();
        }

        public B tools(List<ToolCallback> tools) {
            this.agentExecutorBuilder.tools(tools);
            return this.result();
        }

        public B toolsFromObject(Object objectWithTools) {
            this.agentExecutorBuilder.toolsFromObject(objectWithTools);
            return this.result();
        }

        public B stateSerializer(StateSerializer<AgentExecutor.State> stateSerializer) {
            this.agentExecutorBuilder.stateSerializer(stateSerializer);
            return this.result();
        }

        public B defaultSystem(String systemMessage) {
            this.agentExecutorBuilder.defaultSystem(systemMessage);
            return this.result();
        }
    }
}

