/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.multi_agent.springai;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BiFunction;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.execution.ToolCallResultConverter;
import org.springframework.ai.tool.function.FunctionToolCallback;
import org.springframework.ai.tool.metadata.ToolMetadata;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;

public abstract class AbstractAgent<I, O, B extends Builder<B>>
implements BiFunction<I, ToolContext, O> {
    private final ToolCallback toolCallback;

    public ToolCallback asTool() {
        return this.toolCallback;
    }

    public AbstractAgent(Builder<B> builder) {
        this.toolCallback = FunctionToolCallback.builder((String)Objects.requireNonNull(builder.name, "name cannot be null!"), (BiFunction)this).inputSchema(String.format("{\n  \"$schema\": \"https://json-schema.org/draft/2020-12/schema\",\n  \"type\": \"object\",\n  \"properties\": {\n    \"input\": {\n      \"type\": \"string\",\n      \"description\": \"%s\"\n    }\n  },\n  \"required\": [ \"input\" ]\n}\n", Objects.requireNonNull(builder.parameterDescription, "parameterDescription cannot be null!"))).inputType(builder.inputType).description(builder.description).toolMetadata(builder.toolMetadata).toolCallResultConverter(builder.toolCallResultConverter).build();
    }

    public static abstract class Builder<B extends Builder<B>> {
        String name;
        String description;
        String parameterDescription;
        ToolMetadata toolMetadata;
        ToolCallResultConverter toolCallResultConverter;
        Type inputType;

        protected B result() {
            return (B)this;
        }

        public B name(String name) {
            this.name = name;
            return this.result();
        }

        public B description(String description) {
            this.description = description;
            return this.result();
        }

        public B parameterDescription(String parameterDescription) {
            this.parameterDescription = parameterDescription;
            return this.result();
        }

        public B inputType(Type type) {
            this.inputType = type;
            return this.result();
        }

        public B toolMetadata(ToolMetadata toolMetadata) {
            this.toolMetadata = toolMetadata;
            return this.result();
        }

        public B toolCallResultConverter(ToolCallResultConverter toolCallResultConverter) {
            this.toolCallResultConverter = toolCallResultConverter;
            return this.result();
        }

        public B inputType(ParameterizedTypeReference<?> inputType) {
            Assert.notNull(inputType, (String)"inputType cannot be null");
            this.inputType = inputType.getType();
            return this.result();
        }
    }
}

