/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.quarkus;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bsc.langgraph4j.CompileConfig;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.checkpoint.BaseCheckpointSaver;
import org.bsc.langgraph4j.checkpoint.MemorySaver;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.studio.LangGraphStreamingServer;

public record LangGraphFlow(List<LangGraphStreamingServer.ArgumentMetadata> inputArgs, String title, CompileConfig compileConfig, StateGraph<? extends AgentState> stateGraph) {
    public LangGraphFlow {
        Objects.requireNonNull(stateGraph, "stateGraph is null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<LangGraphStreamingServer.ArgumentMetadata> inputArgs = new ArrayList<LangGraphStreamingServer.ArgumentMetadata>();
        private String title = null;
        private CompileConfig compileConfig;
        private StateGraph<? extends AgentState> stateGraph;

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder addInputStringArg(String name, boolean required) {
            this.inputArgs.add(new LangGraphStreamingServer.ArgumentMetadata(name, LangGraphStreamingServer.ArgumentMetadata.ArgumentType.STRING, required));
            return this;
        }

        public Builder addInputStringArg(String name) {
            return this.addInputStringArg(name, true);
        }

        public Builder addInputImageArg(String name, boolean required) {
            this.inputArgs.add(new LangGraphStreamingServer.ArgumentMetadata(name, LangGraphStreamingServer.ArgumentMetadata.ArgumentType.IMAGE, required));
            return this;
        }

        public Builder addInputImageArg(String name) {
            return this.addInputImageArg(name, true);
        }

        public Builder compileConfig(CompileConfig compileConfig) {
            this.compileConfig = compileConfig;
            return this;
        }

        public <State extends AgentState> Builder stateGraph(StateGraph<State> stateGraph) {
            this.stateGraph = stateGraph;
            return this;
        }

        public LangGraphFlow build() {
            return new LangGraphFlow(this.inputArgs, Optional.ofNullable(this.title).orElse("LangGraph Studio"), Optional.ofNullable(this.compileConfig).orElseGet(() -> CompileConfig.builder().checkpointSaver((BaseCheckpointSaver)new MemorySaver()).build()), this.stateGraph);
        }
    }
}

