/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.quarkus.impl;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.util.Map;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.AsyncEdgeAction;
import org.bsc.langgraph4j.action.AsyncNodeAction;
import org.bsc.langgraph4j.action.EdgeAction;
import org.bsc.langgraph4j.state.AgentState;
import org.bsc.langgraph4j.studio.LangGraphStudioServer;

@ApplicationScoped
public class LangGraphFlowServiceImpl {
    private Map<String, LangGraphStudioServer.Instance> instanceMap;

    @PostConstruct
    void init() throws GraphStateException {
        this.instanceMap = this.sampleFlow();
    }

    @Produces
    public Map<String, LangGraphStudioServer.Instance> getInstanceMap() {
        return this.instanceMap;
    }

    private Map<String, LangGraphStudioServer.Instance> sampleFlow() throws GraphStateException {
        EdgeAction<AgentState> conditionalAge = new EdgeAction<AgentState>(){
            int steps = 0;

            public String apply(AgentState state) {
                if (++this.steps == 2) {
                    this.steps = 0;
                    return "end";
                }
                return "next";
            }
        };
        StateGraph workflow = new StateGraph(AgentState::new).addNode("agent", AsyncNodeAction.node_async(state -> {
            System.out.println("agent ");
            System.out.println(state);
            if (state.value("action_response").isPresent()) {
                return Map.of("agent_summary", "This is just a DEMO summary");
            }
            return Map.of("agent_response", "This is an Agent DEMO response");
        })).addNode("action", AsyncNodeAction.node_async(state -> {
            System.out.print("action: ");
            System.out.println(state);
            return Map.of("action_response", "This is an Action DEMO response");
        })).addEdge(StateGraph.START, "agent").addEdge("action", "agent").addConditionalEdges("agent", AsyncEdgeAction.edge_async((EdgeAction)conditionalAge), Map.of("next", "action", "end", StateGraph.END));
        return Map.of("sample", LangGraphStudioServer.Instance.builder().title("LangGraph Studio (Sample)").graph(workflow).build());
    }
}

