/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.commands;

import java.io.File;
import java.io.PrintStream;
import javax.inject.Inject;
import org.apache.maven.settings.Proxy;
import org.bsc.commands.Constants;
import org.bsc.core.Fe;
import org.bsc.core.MavenHelper;
import org.bsc.ssl.SSLCertificateInfo;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceFactory;
import org.codehaus.swizzle.confluence.Page;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class DownloadPage
extends AbstractProjectCommand
implements Constants {
    @Inject
    @WithAttributes(label="Username", required=true)
    UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", required=true, type="org.jboss.forge.inputType.SECRET")
    UIInput<String> password;
    @Inject
    @WithAttributes(label="Target", required=true, type="org.jboss.forge.inputType.DIRECTORY_PICKER")
    private UIInput<DirectoryResource> target;
    @Inject
    @WithAttributes(label="Title", required=true)
    UIInput<String> title;
    @Inject
    ProjectFactory projectFactory;
    @Inject
    ResourceFactory resourceFactory;
    private final CoordinateBuilder confluencePluginDep = CoordinateBuilder.create((String)"org.bsc.maven:confluence-reporting-maven-plugin:4.4.2");

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(DownloadPage.class).name("confluence-downloadPage").category(Categories.create((String[])new String[]{"Confluence"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        MavenPlugin plugin;
        Configuration conf;
        Project project = Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)builder.getUIContext());
        DirectoryResource ds = (DirectoryResource)project.getRoot();
        DirectoryResource siteDir = ds.getChildDirectory("src/site/confluence");
        this.target.setDefaultValue((Object)(siteDir.exists() ? siteDir : ds));
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        if (pluginFacet.hasPlugin((Coordinate)this.confluencePluginDep) && (conf = (plugin = pluginFacet.getPlugin((Coordinate)this.confluencePluginDep)).getConfig()).hasConfigurationElement("title")) {
            this.title.setDefaultValue((Object)conf.getConfigurationElement("title").getText());
        }
        builder.add(this.username);
        builder.add(this.password);
        builder.add(this.target);
        builder.add(this.title);
    }

    public Result execute(UIExecutionContext context) {
        UIPrompt prompt = context.getPrompt();
        final PrintStream out = context.getUIContext().getProvider().getOutput().out();
        Project project = super.getSelectedProject((UIContextProvider)context);
        MavenFacet facet = (MavenFacet)project.getFacet(MavenFacet.class);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        if (!pluginFacet.hasPlugin((Coordinate)this.confluencePluginDep)) {
            throw new IllegalStateException(String.format("Project hasn't defined Plugin [%s]", "org.bsc.maven:confluence-reporting-maven-plugin:4.4.2"));
        }
        MavenPlugin plugin = pluginFacet.getPlugin((Coordinate)this.confluencePluginDep);
        Configuration conf = plugin.getConfig();
        String endPoint = conf.getConfigurationElement("endPoint").getText();
        final String space = conf.getConfigurationElement("spaceKey").getText();
        try {
            SSLCertificateInfo ssl = new SSLCertificateInfo();
            String resolvedEndpoint = facet.resolveProperties(endPoint);
            ssl.setup(resolvedEndpoint);
            this.confluenceExecute(resolvedEndpoint, (String)this.username.getValue(), (String)this.password.getValue(), new Fe<Confluence, Void>(){

                @Override
                public Void f(Confluence c) throws Exception {
                    Page page = c.getPage(space, (String)DownloadPage.this.title.getValue());
                    String targetPath = String.format("%s/%s.confluence", ((DirectoryResource)DownloadPage.this.target.getValue()).getFullyQualifiedName(), DownloadPage.this.title.getValue());
                    FileResource file = (FileResource)DownloadPage.this.resourceFactory.create((Object)new File(targetPath));
                    if (!file.exists() && !file.createNewFile()) {
                        throw new Exception(String.format("error creating file [%s]", file.getName()));
                    }
                    file.setContents(page.getContent());
                    out.printf("set donloaded content to [%s]\n", file.getName());
                    return null;
                }
            });
        }
        catch (Exception e) {
            return Results.fail((String)"error!", (Throwable)e);
        }
        return Results.success((String)"completed!");
    }

    protected void confluenceExecute(String endpoint, String username, String password, Fe<Confluence, Void> task) throws Exception {
        Confluence confluence = null;
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = MavenHelper.getSettings().getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword(), activeProxy.getNonProxyHosts());
            }
            confluence = ConfluenceFactory.createInstanceDetectingVersion((String)endpoint, proxyInfo, (String)username, (String)password);
            task.f(confluence);
            this.confluenceLogout(confluence);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                this.confluenceLogout(confluence);
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void confluenceLogout(Confluence confluence) {
        if (null == confluence) {
            return;
        }
        try {
            if (confluence.logout()) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

