/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.commands;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bsc.markdown.ToConfluenceSerializer;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.Visitor;

public class MarkdownToConfluence
extends AbstractUICommand {
    @Inject
    @WithAttributes(label="source", required=true, type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInput<FileResource> source;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(MarkdownToConfluence.class).name("confluence-from-md").category(Categories.create((String[])new String[]{"Confluence"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.source);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        final UIOutput output = context.getUIContext().getProvider().getOutput();
        FileResource sourceFR = (FileResource)this.source.getValue();
        Path path = Paths.get(sourceFR.getFullyQualifiedName(), new String[0]);
        String fileNameWithOutExt = path.getFileName().toString().replaceFirst("[.][^.]+$", "");
        ToConfluenceSerializer ser = new ToConfluenceSerializer(){

            protected void notImplementedYet(Node node) {
                output.err().printf("Node [%s] not supported yet.", node.getClass().getSimpleName());
            }
        };
        PegDownProcessor p = new PegDownProcessor(ToConfluenceSerializer.extensions());
        char[] contents = IOUtils.toCharArray((InputStream)sourceFR.getResourceInputStream());
        RootNode root = p.parseMarkdown(contents);
        root.accept((Visitor)ser);
        Path resolved = path.resolveSibling(fileNameWithOutExt.concat(".confluence"));
        FileUtils.writeStringToFile((File)resolved.toFile(), (String)ser.toString());
        return Results.success((String)String.format("file [%s] succesfully created!", resolved.getFileName()));
    }
}

