/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.core;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.bsc.core.F;
import org.jboss.forge.addon.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;

public class MavenHelper {
    private static final String M2_HOME = System.getenv().get("M2_HOME");

    public static Settings getSettings() {
        try {
            SettingsBuildingResult settingsBuildingResult;
            Settings effectiveSettings;
            String userHome = System.getProperty("user.home");
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            settingsRequest.setUserSettingsFile(new File(userHome.concat("/.m2/settings.xml")));
            if (M2_HOME != null) {
                settingsRequest.setGlobalSettingsFile(new File(String.valueOf(M2_HOME) + "/conf/settings.xml"));
            }
            if ((effectiveSettings = (settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsRequest)).getEffectiveSettings()).getLocalRepository() == null) {
                effectiveSettings.setLocalRepository(userHome.concat("/.m2/repository"));
            }
            return effectiveSettings;
        }
        catch (SettingsBuildingException e) {
            throw new Error(e);
        }
    }

    public static Plugin findPluginManagement(Model model, F<Plugin, Boolean> predicate) {
        List plugins = model.getBuild().getPluginManagement().getPlugins();
        for (Plugin p : plugins) {
            if (!predicate.f(p).booleanValue()) continue;
            return p;
        }
        return null;
    }

    public static ConfigurationElementBuilder getOrCreateConfigurationElement(ConfigurationBuilder cb, String id) {
        return (ConfigurationElementBuilder)(cb.hasConfigurationElement(id) ? cb.getConfigurationElement(id) : cb.createConfigurationElement(id));
    }

    public static void addMavenProjectProperty(Project project, String key, String value) {
        MavenFacet mcf = (MavenFacet)project.getFacet(MavenFacet.class);
        MavenHelper.addMavenProjectProperty(mcf, key, value);
    }

    private static void addMavenProjectProperty(MavenFacet mcf, String key, String value) {
        Model pom = mcf.getModel();
        Properties pp = pom.getProperties();
        if (!pp.containsKey(key)) {
            pp.setProperty(key, value);
            mcf.setModel(pom);
        }
    }

    public static void setMavenProjectProperty(Project project, String key, String value) {
        MavenFacet mcf = (MavenFacet)project.getFacet(MavenFacet.class);
        MavenHelper.setMavenProjectProperty(mcf, key, value);
    }

    private static void setMavenProjectProperty(MavenFacet mcf, String key, String value) {
        Model pom = mcf.getModel();
        Properties pp = pom.getProperties();
        pp.setProperty(key, value);
        mcf.setModel(pom);
    }
}

