/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.commands;

import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.maven.settings.Proxy;
import org.bsc.commands.AbstractCommand;
import org.bsc.commands.Constants;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceServiceFactory;
import org.bsc.core.MavenHelper;
import org.bsc.ssl.SSLCertificateInfo;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class DownloadPage
extends AbstractCommand
implements Constants {
    @Inject
    @WithAttributes(label="Username", required=true)
    UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", required=true, type="org.jboss.forge.inputType.SECRET")
    UIInput<String> password;
    @Inject
    @WithAttributes(label="Target", required=true, type="org.jboss.forge.inputType.DIRECTORY_PICKER")
    private UIInput<DirectoryResource> target;
    @Inject
    @WithAttributes(label="Title", required=true)
    UIInput<String> title;
    @Inject
    ProjectFactory projectFactory;
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    DependencyResolver dependencyResolver;
    CoordinateBuilder confluencePluginDep;

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(DownloadPage.class).name("confluence-downloadPage").category(Categories.create((String[])new String[]{"Confluence"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        MavenPlugin plugin;
        Configuration conf;
        this.printBuildInfos(builder);
        Project project = Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)builder.getUIContext());
        DirectoryResource ds = (DirectoryResource)project.getRoot();
        DirectoryResource siteDir = ds.getChildDirectory("src/site/confluence");
        this.target.setDefaultValue((Object)(siteDir.exists() ? siteDir : ds));
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        CoordinateBuilder confluencePluginDep = this.getConfluencePluginDependency(builder);
        if (pluginFacet.hasPlugin((Coordinate)confluencePluginDep) && (conf = (plugin = pluginFacet.getPlugin((Coordinate)confluencePluginDep)).getConfig()).hasConfigurationElement("title")) {
            this.title.setDefaultValue((Object)conf.getConfigurationElement("title").getText());
        }
        builder.add(this.username);
        builder.add(this.password);
        builder.add(this.target);
        builder.add(this.title);
    }

    public Result execute(UIExecutionContext context) {
        CoordinateBuilder confluencePluginDep;
        PrintStream out = context.getUIContext().getProvider().getOutput().out();
        Project project = super.getSelectedProject((UIContextProvider)context);
        MavenFacet facet = (MavenFacet)project.getFacet(MavenFacet.class);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        if (!pluginFacet.hasPlugin((Coordinate)(confluencePluginDep = this.getConfluencePluginDependency(context)))) {
            throw new IllegalStateException(String.format("Project hasn't defined Plugin [%s]", confluencePluginDep));
        }
        MavenPlugin plugin = pluginFacet.getPlugin((Coordinate)confluencePluginDep);
        Configuration conf = plugin.getConfig();
        String endPoint = conf.getConfigurationElement("endPoint").getText();
        String space = conf.getConfigurationElement("spaceKey").getText();
        try {
            ConfluenceService.Credentials credentials = new ConfluenceService.Credentials((String)this.username.getValue(), (String)this.password.getValue());
            SSLCertificateInfo ssl = new SSLCertificateInfo();
            String resolvedEndpoint = facet.resolveProperties(endPoint);
            this.confluenceExecute(resolvedEndpoint, credentials, ssl, c -> {
                String targetPath = String.format("%s/%s.confluence", ((DirectoryResource)this.target.getValue()).getFullyQualifiedName(), this.title.getValue());
                FileResource file = (FileResource)this.resourceFactory.create((Object)new File(targetPath));
                if (!file.exists() && !file.createNewFile()) {
                    throw new Error(String.format("error creating file [%s]", file.getName()));
                }
                ((Optional)c.getPage(space, (String)this.title.getValue()).join()).ifPresent(page -> {
                    try {
                        String content = String.valueOf(page.getClass().getMethod("getContent", new Class[0]).invoke(page, new Object[0]));
                        file.setContents(content);
                        out.printf("set donloaded content to [%s]\n", file.getName());
                    }
                    catch (Exception e) {
                        throw new Error(e);
                    }
                });
            });
        }
        catch (Exception e) {
            return Results.fail((String)"error!", (Throwable)e);
        }
        return Results.success((String)"completed!");
    }

    protected void confluenceExecute(String endpoint, ConfluenceService.Credentials credentials, SSLCertificateInfo ssl, Consumer<ConfluenceService> task) throws Exception {
        ConfluenceService confluence = null;
        ConfluenceProxy proxyInfo = null;
        Proxy activeProxy = MavenHelper.getSettings().getActiveProxy();
        if (activeProxy != null) {
            proxyInfo = new ConfluenceProxy(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword(), activeProxy.getNonProxyHosts());
        }
        confluence = ConfluenceServiceFactory.createInstance((String)endpoint, (ConfluenceService.Credentials)credentials, proxyInfo, (SSLCertificateInfo)ssl);
        confluence.call(task);
    }

    @Override
    <T extends UIContextProvider> CoordinateBuilder getConfluencePluginDependency(T context) {
        if (Objects.isNull(this.confluencePluginDep)) {
            PrintStream out = context.getUIContext().getProvider().getOutput().out();
            List coords = this.dependencyResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((String)String.format("%s:%s", "org.bsc.maven", "confluence-reporting-maven-plugin")));
            if (coords.isEmpty()) {
                out.println("Plugin avaliable dependencies not found! default 5.0 is used");
                return CoordinateBuilder.create((String)String.format("%s:%s", "org.bsc.maven", "confluence-reporting-maven-plugin", "5.0"));
            }
            Coordinate coord = (Coordinate)coords.get(coords.size() - 1);
            out.printf("use plugin [%s]\n", coord.toString());
            this.confluencePluginDep = CoordinateBuilder.create((Coordinate)coord);
        }
        return this.confluencePluginDep;
    }
}

