/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.commands;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Server;
import org.bsc.commands.AbstractCommand;
import org.bsc.commands.Constants;
import org.bsc.confluence.ConfluenceService;
import org.bsc.core.MavenHelper;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.maven.plugins.Configuration;
import org.jboss.forge.addon.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class Setup
extends AbstractCommand
implements Constants {
    @Inject
    @WithAttributes(label="ServerId", required=true)
    UISelectOne<Server> serverIds;
    @Inject
    @WithAttributes(label="Confluence EndPoint with suffix '/rest/api' or '/rpc/xmlrpc' ", required=true)
    UIInput<String> endPoint;
    @Inject
    @WithAttributes(label="Space Key Home", required=true)
    UIInput<String> spaceKey;
    @Inject
    @WithAttributes(label="Parent page title", required=true, defaultValue="Home")
    UIInput<String> parentPageTitle;
    @Inject
    @WithAttributes(label="site format", required=true, defaultValue="xml")
    UISelectOne<String> siteFormatType;
    @Inject
    ProjectFactory projectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(Setup.class).name("confluence-setup").category(Categories.create((String[])new String[]{"Confluence"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.printBuildInfos(builder);
        this.serverIds.setValueChoices(() -> MavenHelper.getSettings().getServers());
        this.serverIds.setItemLabelConverter(server -> server == null ? "" : server.getId());
        this.endPoint.addValidator(vc -> {
            InputComponent input = vc.getCurrentInputComponent();
            String value = String.valueOf(input.getValue());
            try {
                URL url = new URL(value);
                boolean validSuffix = Arrays.stream(ConfluenceService.Protocol.values()).anyMatch(protocol -> url.getPath().endsWith(protocol.path()));
                if (!validSuffix) {
                    String msg = Arrays.stream(ConfluenceService.Protocol.values()).map(p -> p.path()).collect(Collectors.joining(",", "Endpoint has not a valid suffix! Allowed [", "]"));
                    throw new MalformedURLException(msg);
                }
            }
            catch (MalformedURLException e) {
                vc.addValidationError(input, e.getMessage());
            }
        });
        Project project = Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)builder.getUIContext());
        MavenFacet mavenFacet = (MavenFacet)project.getFacet(MavenFacet.class);
        String result = mavenFacet.getModel().getProperties().getProperty("confluence.endPoint");
        if (result != null) {
            this.endPoint.setValue((Object)result);
        } else {
            PrintStream out = builder.getUIContext().getProvider().getOutput().out();
            out.printf("the variable '%s' not found in current model", "confluence.endPoint");
        }
        List<String> formats = Arrays.asList("xml", "yaml");
        this.siteFormatType.setValueChoices(formats);
        this.siteFormatType.setDefaultValue((Object)formats.get(0));
        builder.add(this.serverIds);
        builder.add(this.endPoint);
        builder.add(this.spaceKey);
        builder.add(this.parentPageTitle);
        builder.add(this.siteFormatType);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    public Result execute(UIExecutionContext context) {
        UIPrompt prompt = context.getPrompt();
        PrintStream out = context.getUIContext().getProvider().getOutput().out();
        Project project = super.getSelectedProject((UIContextProvider)context);
        MavenFacet facet = (MavenFacet)project.getFacet(MavenFacet.class);
        Model mProject = facet.getModel();
        String siteDir = String.format("%s/src/site/confluence", project.getRoot().getFullyQualifiedName());
        File siteDirFile = new File(siteDir);
        while (!siteDirFile.exists()) {
            boolean createFolder = prompt.promptBoolean(String.format("Do you want create missing folder [%s]: ", siteDirFile.getPath()), true);
            if (createFolder) {
                boolean success = siteDirFile.mkdirs();
                if (success) {
                    out.println("folder created!");
                    break;
                }
                String msg = String.format("error creating folder [%s]!", siteDir);
                out.printf(msg, new Object[0]);
                return Results.fail((String)msg);
            }
            String newFolder = prompt.prompt("Please, give me the site folder relative to ${basedir}. press enter to abort: ");
            if (newFolder == null || newFolder.isEmpty()) {
                out.println("setup interrupted!");
                return Results.fail((String)"setup interrupted!");
            }
            siteDirFile = new File(mProject.getProjectDirectory(), newFolder);
        }
        try {
            File f = new File(siteDirFile, "home.confluence");
            if (!f.exists()) {
                InputStream confluenceTemplatePage = this.getClass().getClassLoader().getResourceAsStream("template.confluence");
                FileWriter confluenceHomePage = new FileWriter(f);
                IOUtil.copy((InputStream)confluenceTemplatePage, (Writer)confluenceHomePage);
            }
        }
        catch (IOException ex) {
            out.println("error copying home page template ....! Set VERBOSE for details");
        }
        String templateSite = String.format("site.%s", this.siteFormatType.getValue());
        File f = new File(siteDirFile, templateSite);
        if (!f.exists()) {
            InputStream siteTemplatePage = this.getClass().getClassLoader().getResourceAsStream(templateSite);
            try (FileWriter sitePage = new FileWriter(f);){
                IOUtil.copy((InputStream)siteTemplatePage, (Writer)sitePage);
            }
            catch (IOException ex) {
                out.println("error copying site template ....! Set VERBOSE for details");
            }
        }
        this.updateOrCreateConfluenceMavenPlugin(context, project, mProject);
        return Results.success((String)"completed!");
    }

    private void updateOrCreateConfluenceMavenPlugin(UIExecutionContext context, Project project, Model mProject) {
        ConfigurationBuilder configurationBuilder;
        MavenPluginBuilder pluginBuilder;
        MavenPlugin _plugin;
        CoordinateBuilder confluencePluginDep = this.getConfluencePluginDependency(context);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        if (pluginFacet.hasPlugin((Coordinate)confluencePluginDep)) {
            _plugin = pluginFacet.getPlugin((Coordinate)confluencePluginDep);
            pluginBuilder = MavenPluginBuilder.create((MavenPlugin)_plugin);
            configurationBuilder = ConfigurationBuilder.create((Configuration)pluginBuilder.getConfig(), (MavenPluginBuilder)pluginBuilder);
        } else {
            _plugin = null;
            pluginBuilder = MavenPluginBuilder.create().setCoordinate((Coordinate)confluencePluginDep);
            configurationBuilder = pluginBuilder.createConfiguration();
        }
        ConfigurationElementBuilder _elem = MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "serverId");
        _elem.setText(((Server)this.serverIds.getValue()).getId());
        _elem = MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "endPoint");
        String param = (String)this.endPoint.getValue();
        if (param.trim().endsWith("/")) {
            param = param.substring(0, param.length() - 1);
        }
        MavenHelper.setMavenProjectProperty(project, "confluence.endPoint", param);
        _elem.setText(String.format("${%s}", "confluence.endPoint"));
        _elem = MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "spaceKey");
        _elem.setText((String)this.spaceKey.getValue());
        _elem = MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "parentPageTitle");
        _elem.setText((String)this.parentPageTitle.getValue());
        MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "wikiFilesExt").setText(".confluence");
        MavenHelper.getOrCreateConfigurationElement(configurationBuilder, "properties");
        pluginBuilder.setConfiguration((Configuration)configurationBuilder);
        if (_plugin != null) {
            pluginFacet.updatePlugin((MavenPlugin)pluginBuilder);
        } else {
            pluginFacet.addPlugin((MavenPlugin)pluginBuilder);
        }
    }
}

