/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;
import org.bsc.maven.confluence.plugin.AbstractConfluenceSiteMojo;
import org.bsc.maven.confluence.plugin.ConfluenceSink;
import org.bsc.maven.confluence.plugin.PluginConfluenceDocGenerator;
import org.bsc.maven.confluence.plugin.ReportingResolutionListener;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.bsc.maven.reporting.model.Site;
import org.bsc.maven.reporting.renderer.DependenciesRenderer;
import org.bsc.maven.reporting.renderer.ProjectSummaryRenderer;
import org.bsc.maven.reporting.renderer.ScmRenderer;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;

@Mojo(name="deploy", threadSafe=true)
public class ConfluenceDeployMojo
extends AbstractConfluenceSiteMojo {
    private static final String PROJECT_DEPENDENCIES_VAR = "project.dependencies";
    private static final String PROJECT_SCM_MANAGER_VAR = "project.scmManager";
    private static final String PROJECT_SUMMARY_VAR = "project.summary";
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector collector;
    @Component(role=ArtifactFactory.class)
    protected ArtifactFactory factory;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected I18N i18n;
    @Parameter(property="project.build.directory/generated-site/confluence", required=true)
    protected File outputDirectory;
    @Component(role=ScmManager.class)
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepos;
    @Component
    protected MojoScanner mojoScanner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Locale locale = Locale.getDefault();
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        this.loadUserInfoFromSettings();
        Site site = null;
        if (this.isSiteDescriptorValid()) {
            site = super.createFromModel();
        }
        if (site != null) {
            site.setBasedir(this.getSiteDescriptor());
            if (site.getHome().getName() != null) {
                this.setTitle(site.getHome().getName());
            } else {
                site.getHome().setName(this.getTitle());
            }
            List<String> _labels = this.getLabels();
            if (!_labels.isEmpty()) {
                site.getLabels().addAll(_labels);
            }
        } else {
            site = super.createFromFolder();
        }
        site.print(System.out);
        super.initTemplateProperties();
        if (this.project.getPackaging().equals("maven-plugin")) {
            this.generatePluginReport(site, locale);
        } else {
            this.generateProjectReport(site, locale);
        }
    }

    private void generateProjectReport(final Site site, Locale locale) throws MojoExecutionException {
        final String title = this.getTitle();
        MiniTemplator t = null;
        try {
            t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(Site.processUri(site.getHome().getUri()), this.getCharset());
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            throw new MojoExecutionException("error loading template", e);
        }
        super.addProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w);
        new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale).render();
        try {
            String project_summary_var = w.toString();
            this.getProperties().put(PROJECT_SUMMARY_VAR, project_summary_var);
            t.setVariable(PROJECT_SUMMARY_VAR, project_summary_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        new ScmRenderer(this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection).render();
        try {
            String project_scm_var = w.toString();
            this.getProperties().put(PROJECT_SCM_MANAGER_VAR, project_scm_var);
            t.setVariable(PROJECT_SCM_MANAGER_VAR, project_scm_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            String project_dependencies_var = w.toString();
            this.getProperties().put(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
            t.setVariable(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().warn((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        final String wiki = t.generateOutput();
        super.confluenceExecute(new AbstractBaseConfluenceMojo.ConfluenceTask(){

            @Override
            public void execute(Confluence confluence) throws Exception {
                if (!ConfluenceDeployMojo.this.isSnapshot() && ConfluenceDeployMojo.this.isRemoveSnapshots()) {
                    String snapshot = title.concat("-SNAPSHOT");
                    ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
                    boolean deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)ConfluenceDeployMojo.this.getSpaceKey(), (String)ConfluenceDeployMojo.this.getParentPageTitle(), (String)snapshot);
                    if (deleted) {
                        ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
                    }
                }
                Page confluencePage = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)ConfluenceDeployMojo.this.getSpaceKey(), (String)ConfluenceDeployMojo.this.getParentPageTitle(), (String)title);
                confluencePage.setContent(wiki);
                confluencePage = confluence.storePage(confluencePage);
                for (String label : site.getHome().getComputedLabels()) {
                    confluence.addLabelByName(label, Long.parseLong(confluencePage.getId()));
                }
                ConfluenceDeployMojo.this.generateChildren(confluence, site.getHome(), confluencePage, ConfluenceDeployMojo.this.getSpaceKey(), title, title);
            }
        });
    }

    private ReportingResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportingResolutionListener listener = new ReportingResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public String getDescription(Locale locale) {
        return "confluence";
    }

    public String getOutputName() {
        return "confluence";
    }

    public String getName(Locale locale) {
        return "confluence";
    }

    private static List<ComponentDependency> toComponentDependencies(List<Dependency> dependencies) {
        return GeneratorUtils.toComponentDependencies(dependencies);
    }

    private void generatePluginReport(final Site site, Locale locale) throws MojoExecutionException {
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        final PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        try {
            ArrayList<ComponentDependency> deps = new ArrayList<ComponentDependency>();
            deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getRuntimeDependencies()));
            deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getCompileDependencies()));
            pluginDescriptor.setDependencies(deps);
            pluginDescriptor.setDescription(this.project.getDescription());
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            request.setEncoding(this.getEncoding());
            request.setLocal(this.local);
            request.setRemoteRepos(this.remoteRepos);
            request.setSkipErrorNoDescriptorsFound(false);
            request.setDependencies(this.dependencies);
            try {
                this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
            }
            catch (InvalidPluginDescriptorException e) {
                this.getLog().warn((CharSequence)String.format("Plugin without mojos. %s\nMojoScanner:%s", e.getMessage(), this.mojoScanner.getClass()));
            }
            super.confluenceExecute(new AbstractBaseConfluenceMojo.ConfluenceTask(){

                @Override
                public void execute(Confluence confluence) throws Exception {
                    ConfluenceDeployMojo.this.outputDirectory.mkdirs();
                    ConfluenceDeployMojo.this.getLog().info((CharSequence)("speceKey=" + ConfluenceDeployMojo.this.getSpaceKey() + " parentPageTitle=" + ConfluenceDeployMojo.this.getParentPageTitle()));
                    Page confluencePage = confluence.getPage(ConfluenceDeployMojo.this.getSpaceKey(), ConfluenceDeployMojo.this.getParentPageTitle());
                    PluginConfluenceDocGenerator generator = new PluginConfluenceDocGenerator(ConfluenceDeployMojo.this, confluence, confluencePage, ConfluenceDeployMojo.this.templateWiki);
                    DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(ConfluenceDeployMojo.this.project, pluginDescriptor);
                    generator.execute(ConfluenceDeployMojo.this.outputDirectory, (PluginToolsRequest)request);
                    for (String label : site.getHome().getComputedLabels()) {
                        confluence.addLabelByName(label, Long.parseLong(confluencePage.getId()));
                    }
                    String title = ConfluenceDeployMojo.this.getTitle();
                    ConfluenceDeployMojo.this.generateChildren(confluence, site.getHome(), confluencePage, ConfluenceDeployMojo.this.getSpaceKey(), title, title);
                }
            });
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException(String.format("Error extracting plugin descriptor: %s", e.getLocalizedMessage()), (Exception)((Object)e));
        }
    }
}

