/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;
import org.bsc.maven.reporting.model.ProcessUriException;
import org.bsc.maven.reporting.model.Site;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;

public abstract class AbstractConfluenceMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/site/confluence/template.wiki")
    protected File templateWiki;
    @Parameter(defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;
    @Parameter(defaultValue="${basedir}/src/site/confluence/children")
    private File childrenFolder;
    @Parameter(property="confluence.removeSnapshots", required=false, defaultValue="false")
    protected boolean removeSnapshots = false;
    @Parameter(property="confluence.childrenTitlesPrefixed", required=false, defaultValue="true")
    protected boolean childrenTitlesPrefixed = true;
    @Parameter
    List<String> labels;
    @Parameter(alias="title", property="project.build.finalName", required=false)
    private String title;
    @Parameter(property="wikiFilesExt", required=false, defaultValue=".wiki")
    private String wikiFilesExt;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;

    protected File getChildrenFolder() {
        return this.childrenFolder;
    }

    protected File getAttachmentFolder() {
        return this.attachmentFolder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final Charset getCharset() {
        if (this.encoding == null) {
            this.getLog().warn((CharSequence)"encoding is null! default charset will be used");
            return Charset.defaultCharset();
        }
        try {
            Charset result = Charset.forName(this.encoding);
            return result;
        }
        catch (UnsupportedCharsetException e) {
            this.getLog().warn((CharSequence)String.format("encoding [%s] is not valid! default charset will be used", this.encoding));
            return Charset.defaultCharset();
        }
    }

    protected final String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public boolean isChildrenTitlesPrefixed() {
        return this.childrenTitlesPrefixed;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return this.labels;
    }

    protected void initTemplateProperties() {
        this.processProperties();
        this.getProperties().put("pageTitle", this.getTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    public void addStdProperties(MiniTemplator t) {
        Map<String, String> props = this.getProperties();
        if (props == null || props.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                try {
                    t.setVariable(e.getKey(), e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().warn((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    protected <T extends Site.Page> Page generateChild(Confluence confluence, T child, String spaceKey, String parentPageTitle, String titlePrefix) {
        URI source = child.getUri(this.getProject(), this.getFileExt());
        this.getLog().info((CharSequence)String.format("generateChild spacekey=[%s] parentPageTtile=[%s]\n%s", spaceKey, parentPageTitle, child.toString()));
        try {
            String snapshot;
            boolean deleted;
            if (!this.isSnapshot() && this.isRemoveSnapshots() && (deleted = ConfluenceUtils.removePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)(snapshot = titlePrefix.concat("-SNAPSHOT"))))) {
                this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
            }
            String pageName = !this.isChildrenTitlesPrefixed() ? child.getName() : String.format("%s - %s", titlePrefix, child.getName());
            Page p = ConfluenceUtils.getOrCreatePage((Confluence)confluence, (String)spaceKey, (String)parentPageTitle, (String)pageName);
            if (source != null) {
                InputStream is = Site.processUri(source, this.getTitle());
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(is, this.getCharset());
                if (!child.isIgnoreVariables()) {
                    this.addStdProperties(t);
                    t.setVariableOpt("childTitle", pageName);
                }
                p.setContent(t.generateOutput());
            }
            p = confluence.storePage(p);
            for (String label : child.getComputedLabels()) {
                confluence.addLabelByName(label, Long.parseLong(p.getId()));
            }
            child.setName(pageName);
            return p;
        }
        catch (Exception e) {
            String msg = "error loading template";
            this.getLog().error((CharSequence)"error loading template", (Throwable)e);
            return null;
        }
    }

    private void processProperties() {
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            try {
                String v = e.getValue();
                if (v == null) {
                    this.getLog().warn((CharSequence)String.format("property [%s] has null value!", e.getKey()));
                    continue;
                }
                URI uri = new URI(v);
                if (uri.getScheme() == null) continue;
                this.getProperties().put(e.getKey(), this.processUri(uri, this.getCharset()));
            }
            catch (ProcessUriException ex) {
                this.getLog().warn((CharSequence)String.format("error processing value of property [%s]\n%s", e.getKey(), ex.getMessage()));
                if (ex.getCause() == null) continue;
                this.getLog().debug(ex.getCause());
            }
            catch (URISyntaxException ex) {
                this.getLog().debug((CharSequence)String.format("property [%s] is not a valid uri", e.getKey()));
            }
        }
    }

    private String processUri(URI uri, Charset charset) throws ProcessUriException {
        try {
            InputStream is = Site.processUri(uri, this.getTitle());
            return this.toString(is, charset);
        }
        catch (Exception ex) {
            throw new ProcessUriException("error reading content!", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream");
        }
        InputStreamReader r = null;
        try {
            int c;
            r = new InputStreamReader(stream, charset);
            StringBuilder contents = new StringBuilder(4096);
            while ((c = ((Reader)r).read()) != -1) {
                contents.append((char)c);
            }
            String string = contents.toString();
            return string;
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
        }
    }
}

