/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceExportDecorator;
import org.codehaus.swizzle.confluence.ExportFormat;
import org.codehaus.swizzle.confluence.Page;

@Mojo(name="export", threadSafe=true, requiresProject=false)
public class ConfluenceExportMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(alias="outputType", property="outputType", defaultValue="pdf")
    private String outputType;
    @Parameter(alias="outputFile")
    private File outputFile;
    @Parameter(property="project.build.directory", readonly=true)
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.loadUserInfoFromSettings();
        super.confluenceExecute(new AbstractBaseConfluenceMojo.ConfluenceTask(){

            @Override
            public void execute(Confluence confluence) throws Exception {
                ExportFormat exfmt = ExportFormat.valueOf((String)ConfluenceExportMojo.this.outputType.toUpperCase());
                Page parentPage = ConfluenceExportMojo.this.loadParentPage(confluence);
                if (ConfluenceExportMojo.this.outputFile == null) {
                    ConfluenceExportMojo.this.outputFile = ConfluenceExportMojo.this.outputDirectory == null ? new File(String.format("%s.%s", ConfluenceExportMojo.this.pageTitle, exfmt.name().toLowerCase())) : new File(ConfluenceExportMojo.this.outputDirectory, String.format("%s.%s", ConfluenceExportMojo.this.pageTitle, exfmt.name().toLowerCase()));
                }
                FileUtils.forceMkdir((File)new File(ConfluenceExportMojo.this.outputFile.getParent()));
                String url = ConfluenceExportMojo.super.getEndPoint().replace("/rpc/xmlrpc", "");
                ConfluenceExportDecorator exporter = new ConfluenceExportDecorator(confluence, url, ConfluenceExportMojo.super.getUsername(), ConfluenceExportMojo.super.getPassword());
                exporter.exportPage(parentPage.getSpace(), parentPage.getTitle(), exfmt, ConfluenceExportMojo.this.outputFile);
            }
        });
    }
}

