/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.IOUtils;
import org.apache.maven.project.MavenProject;
import org.bsc.markdown.ToConfluenceSerializer;
import org.bsc.maven.reporting.model.ChildListProxy;
import org.pegdown.PegDownProcessor;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="site", namespace="https://github.com/bsorrentino/maven-confluence-plugin")
public class Site {
    protected static final Stack<Site> _SITE = new Stack();
    private static final Logger LOGGER = LoggerFactory.getLogger(Site.class);
    private transient File basedir;
    private List<String> labels;
    Page home;

    static InputStream processMarkdown(InputStream is, final String homePageTitle) throws IOException {
        final char[] contents = IOUtils.toCharArray((InputStream)is);
        PegDownProcessor p = new PegDownProcessor(ToConfluenceSerializer.extensions());
        RootNode root = p.parseMarkdown(contents);
        ToConfluenceSerializer ser = new ToConfluenceSerializer(){

            protected void notImplementedYet(Node node) {
                int[] lc = ToConfluenceSerializer.lineAndColFromNode((String)new String(contents), (Node)node);
                throw new UnsupportedOperationException(String.format("Node [%s] not supported yet. line=[%d] col=[%d]", node.getClass().getSimpleName(), lc[0], lc[1]));
            }

            protected String getHomePageTitle() {
                return homePageTitle;
            }
        };
        root.accept((Visitor)ser);
        return new ByteArrayInputStream(ser.toString().getBytes());
    }

    public static InputStream processUri(URI uri, String homePageTitle) throws Exception {
        InputStream result;
        boolean isMarkdown;
        if (uri == null) {
            throw new IllegalArgumentException("uri is null!");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new Exception(String.format("uri [%s] is invalid!", String.valueOf(uri)));
        }
        String source = uri.getRawSchemeSpecificPart();
        String path = uri.getRawPath();
        boolean bl = isMarkdown = path != null && path.endsWith(".md");
        if ("classpath".equalsIgnoreCase(scheme)) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            result = cl.getResourceAsStream(source);
            if (result == null) {
                cl = Site.class.getClassLoader();
                InputStream is = cl.getResourceAsStream(source);
                InputStream inputStream = result = isMarkdown ? Site.processMarkdown(is, homePageTitle) : is;
                if (result == null) {
                    throw new Exception(String.format("resource [%s] doesn't exist in classloader", source));
                }
            }
        } else {
            try {
                URL url = uri.toURL();
                InputStream is = url.openStream();
                result = isMarkdown ? Site.processMarkdown(is, homePageTitle) : is;
            }
            catch (IOException e) {
                throw new Exception(String.format("error opening url [%s]!", source), e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            String resultString = IOUtils.toString((InputStream)result);
            LOGGER.debug("Result: {}", (Object)resultString);
            result = new ByteArrayInputStream(resultString.getBytes());
        }
        return result;
    }

    public Site() {
        _SITE.push(this);
    }

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XmlElement(name="label")
    public List<String> getLabels() {
        if (null == this.labels) {
            Site site = this;
            synchronized (site) {
                this.labels = new ArrayList<String>();
            }
        }
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @XmlElement(name="home", required=true)
    public Page getHome() {
        return this.home;
    }

    public void setHome(Page home) {
        this.home = home;
    }

    private void printSource(PrintStream out, int level, char c, Source source) {
        for (int i = 0; i < level; ++i) {
            System.out.print(c);
        }
        out.print(" ");
        out.println(source);
    }

    private void printChildren(PrintStream out, int level, Page parent) {
        this.printSource(out, level, '-', parent);
        for (Attachment attach : parent.getAttachments()) {
            this.printSource(out, level + 1, '#', attach);
        }
        for (Page child : parent.getChildren()) {
            this.printChildren(out, level + 1, child);
        }
    }

    public void print(PrintStream out) {
        out.println("Site");
        if (!this.getLabels().isEmpty()) {
            out.println(" Labels");
            for (String label : this.getLabels()) {
                out.printf("  %s\n", label);
            }
        }
        this.printChildren(out, 0, this.getHome());
    }

    public static class Page
    extends Source {
        List<Attachment> attachments;
        private List<String> labels;
        private Page parent;
        List<Page> children;
        boolean ignoreVariables = false;

        @Deprecated
        public File getSource() {
            this.validateSource();
            URI _uri = super.getUri();
            if (!_uri.isAbsolute() && !"file".equals(_uri.getScheme())) {
                throw new IllegalArgumentException("uri not represent a file");
            }
            return new File(_uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @XmlElement(name="label")
        public List<String> getLabels() {
            if (null == this.labels) {
                Page page = this;
                synchronized (page) {
                    this.labels = new ArrayList<String>();
                }
            }
            return this.labels;
        }

        public void setLabels(List<String> labels) {
            this.labels = labels;
        }

        @XmlTransient
        public final void setParent(Page p) {
            this.parent = p;
        }

        @XmlTransient
        public final List<String> getComputedLabels() {
            List<String> _labels;
            if (this.site != null && (_labels = this.site.getLabels()) != null && !_labels.isEmpty()) {
                _labels = new ArrayList<String>(_labels);
                _labels.addAll(this.getLabels());
                return _labels;
            }
            return this.getLabels();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @XmlElement(name="child")
        public List<Page> getChildren() {
            if (null == this.children) {
                Page page = this;
                synchronized (page) {
                    this.children = ChildListProxy.newInstance(this);
                }
            }
            return this.children;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @XmlElement(name="attachment")
        public List<Attachment> getAttachments() {
            if (null == this.attachments) {
                Page page = this;
                synchronized (page) {
                    this.attachments = new ArrayList<Attachment>();
                }
            }
            return this.attachments;
        }

        public URI getUri(MavenProject project, String ext) {
            if (this.getUri() == null) {
                if (project == null) {
                    throw new IllegalArgumentException("project is null");
                }
                if (this.getName() == null) {
                    throw new IllegalStateException("name is null");
                }
                this.setUri(this.site.getBasedir().toURI().resolve(this.getName().concat(ext)));
            }
            return this.getUri();
        }

        @XmlAttribute(name="ignore-variables")
        public boolean isIgnoreVariables() {
            return this.ignoreVariables;
        }

        public void setIgnoreVariables(boolean value) {
            this.ignoreVariables = value;
        }
    }

    public static class Attachment
    extends Source {
        public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
        public static final String DEFAULT_VERSION = "0";
        String contentType = "application/octet-stream";
        String comment;
        String version = "0";

        @XmlAttribute
        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @XmlAttribute
        public String getComment() {
            if (this.comment == null) {
                if (this.getName() == null) {
                    this.setComment("attached by maven-confluence-plugin");
                } else {
                    this.setComment(String.format("%s - attached by maven-confluence-plugin", this.getName()));
                }
            }
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @XmlAttribute
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean hasBeenUpdatedFrom(Date date) {
            if (date != null) {
                this.validateSource();
                URI _uri = super.getUri();
                if (!_uri.isAbsolute() || "file".equals(_uri.getScheme())) {
                    File f = new File(_uri);
                    return f.lastModified() > date.getTime();
                }
            }
            return true;
        }
    }

    protected static class Source {
        protected final transient Site site = _SITE.peek();
        private URI uri;
        String name;

        @XmlAttribute
        public final URI getUri() {
            if (this.uri != null && !this.uri.isAbsolute() && this.site.getBasedir() != null) {
                return this.site.getBasedir().toURI().resolve(this.uri);
            }
            return this.uri;
        }

        public final void setUri(URI value) {
            if (null == value) {
                throw new IllegalArgumentException("uri is null");
            }
            this.uri = value;
        }

        @XmlAttribute
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.getName() + " - " + String.valueOf(this.getUri());
        }

        protected void validateSource() {
            if (null == this.uri) {
                throw new IllegalStateException("uri is null");
            }
        }
    }
}

