/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.PageSummary;

@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.loadUserInfoFromSettings();
        super.confluenceExecute(new AbstractBaseConfluenceMojo.ConfluenceTask(){

            @Override
            public void execute(Confluence confluence) throws Exception {
                Page parentPage = confluence.getPage(ConfluenceDeleteMojo.this.getSpaceKey(), ConfluenceDeleteMojo.this.getParentPageTitle());
                if (parentPage == null) {
                    ConfluenceDeleteMojo.this.getLog().warn((CharSequence)String.format("Parent page [%s] in [%s] not found!", ConfluenceDeleteMojo.this.getParentPageTitle(), ConfluenceDeleteMojo.this.getSpaceKey()));
                    return;
                }
                PageSummary root = ConfluenceUtils.findPageByTitle((Confluence)confluence, (String)parentPage.getId(), (String)ConfluenceDeleteMojo.this.pageTitle);
                if (root == null) {
                    ConfluenceDeleteMojo.this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", ConfluenceDeleteMojo.this.getParentPageTitle(), ConfluenceDeleteMojo.this.pageTitle, ConfluenceDeleteMojo.this.getSpaceKey()));
                    return;
                }
                if (ConfluenceDeleteMojo.this.recursive) {
                    List descendents = confluence.getDescendents(root.getId());
                    if (descendents == null || descendents.isEmpty()) {
                        ConfluenceDeleteMojo.this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", ConfluenceDeleteMojo.this.getParentPageTitle(), ConfluenceDeleteMojo.this.pageTitle, ConfluenceDeleteMojo.this.getSpaceKey()));
                    } else {
                        for (PageSummary descendent : descendents) {
                            ConfluenceDeleteMojo.this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s]  has been removed!", ConfluenceDeleteMojo.this.getParentPageTitle(), ConfluenceDeleteMojo.this.pageTitle, descendent.getTitle()));
                            confluence.removePage(descendent.getId());
                        }
                    }
                }
                confluence.removePage(root.getId());
                ConfluenceDeleteMojo.this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", ConfluenceDeleteMojo.this.getParentPageTitle(), ConfluenceDeleteMojo.this.pageTitle, ConfluenceDeleteMojo.this.getSpaceKey()));
            }
        });
    }
}

