/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.mavenplugins.gitlog;

import com.github.qwazer.mavenplugins.gitlog.CalculateRuleForSinceTagName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.util.StringUtils;

public class VersionUtil {
    public static String calculateVersionTagNamePart(String version, CalculateRuleForSinceTagName calculateRuleForSinceTagName) {
        if (calculateRuleForSinceTagName.equals((Object)CalculateRuleForSinceTagName.NO_RULE)) {
            return null;
        }
        ArtifactVersion artifactVersion = VersionUtil.parseArtifactVersion(version);
        int major = artifactVersion.getMajorVersion();
        int minor = artifactVersion.getMinorVersion();
        int patch = artifactVersion.getIncrementalVersion();
        switch (calculateRuleForSinceTagName) {
            case CURRENT_MAJOR_VERSION: {
                minor = 0;
                patch = 0;
                break;
            }
            case CURRENT_MINOR_VERSION: {
                patch = 0;
                break;
            }
            case LATEST_RELEASE_VERSION: {
                patch = patch == 0 ? 0 : patch - 1;
                break;
            }
            default: {
                throw new RuntimeException("cannot parse " + (Object)((Object)calculateRuleForSinceTagName));
            }
        }
        return major + "." + minor + "." + patch;
    }

    protected static ArtifactVersion parseArtifactVersion(String version) {
        version = version.replaceAll("\\s", "");
        version = VersionUtil.removeNonDigitPrefix(version);
        version = VersionUtil.addSuffixDelimeterIfNeeded(version);
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        if (ArtifactUtils.isSnapshot((String)version)) {
            artifactVersion = new DefaultArtifactVersion(StringUtils.substring((String)version, (int)0, (int)(version.length() - "SNAPSHOT".length() - 1)));
        }
        return artifactVersion;
    }

    protected static String addSuffixDelimeterIfNeeded(String version) {
        int i;
        if (version.contains("-")) {
            return version;
        }
        for (i = 0; i < version.length() && (Character.isDigit(version.charAt(i)) || version.charAt(i) == '.'); ++i) {
        }
        if (i > 0) {
            if (version.charAt(i - 1) == '.') {
                return version.substring(0, i - 1) + "-" + version.substring(i, version.length());
            }
            return version.substring(0, i) + "-" + version.substring(i, version.length());
        }
        return version;
    }

    protected static String removeNonDigitPrefix(String version) {
        if (version != null && !version.isEmpty() && !Character.isDigit(version.charAt(0))) {
            Matcher matcher = Pattern.compile("\\d+").matcher(version);
            int i = 0;
            if (matcher.find()) {
                i = matcher.start();
            }
            if (i > 0) {
                version = StringUtils.substring((String)version, (int)i, (int)version.length());
            }
        }
        return version;
    }

    public static Collection<String> filterTagNamesByTagNamePart(Collection<String> tagNames, String versionTagNamePart) {
        ArrayList<String> list = new ArrayList<String>();
        for (String tagName : tagNames) {
            if (!tagName.contains(versionTagNamePart)) continue;
            list.add(tagName);
        }
        return list;
    }

    public static String findNearestVersionTagsBefore(Collection<String> versionTagList, String versionTagNamePart) {
        HashMap<ArtifactVersion, String> map = new HashMap<ArtifactVersion, String>();
        for (String versionTag : versionTagList) {
            map.put(VersionUtil.parseArtifactVersion(versionTag), versionTag);
        }
        ArtifactVersion currentVersion = VersionUtil.parseArtifactVersion(versionTagNamePart);
        ArrayList sortedList = new ArrayList(map.keySet());
        Collections.sort(sortedList);
        int index = Collections.binarySearch(sortedList, currentVersion, null);
        if (index >= 0) {
            return (String)map.get(sortedList.get(index));
        }
        if (sortedList.size() > 0) {
            if (-index - 2 >= 0) {
                return (String)map.get(sortedList.get(-index - 2));
            }
            return null;
        }
        return null;
    }

    public static LinkedList<String> sortAndFilter(Collection<String> versionNameList, String start, String end) {
        final ArtifactVersion startVersion = VersionUtil.parseArtifactVersion(start);
        final ArtifactVersion endVersion = end != null && !end.isEmpty() ? VersionUtil.parseArtifactVersion(end) : null;
        if (endVersion != null && startVersion.compareTo((Object)endVersion) > 0) {
            throw new IllegalArgumentException(String.format("startVersion %s must be less or equals to endVersion %s", startVersion, endVersion));
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        HashMap<ArtifactVersion, String> map = new HashMap<ArtifactVersion, String>();
        for (String versionTag : versionNameList) {
            map.put(VersionUtil.parseArtifactVersion(versionTag), versionTag);
        }
        ArrayList artifactVersionSet = new ArrayList(map.keySet());
        CollectionUtils.filter(artifactVersionSet, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                ArtifactVersion current = (ArtifactVersion)o;
                return endVersion != null ? startVersion.compareTo((Object)current) <= 0 && endVersion.compareTo((Object)current) >= 0 : startVersion.compareTo((Object)current) <= 0;
            }
        });
        Collections.sort(artifactVersionSet);
        for (ArtifactVersion artifactVersion : artifactVersionSet) {
            linkedList.add((String)map.get(artifactVersion));
        }
        return linkedList;
    }
}

