/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.bsc.maven.confluence.plugin.SSLCertificateInfo;
import org.bsc.maven.plugin.confluence.ConfluenceUtils;
import org.codehaus.swizzle.confluence.Confluence;
import org.codehaus.swizzle.confluence.ConfluenceFactory;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

public abstract class AbstractBaseConfluenceMojo
extends AbstractMojo {
    @Parameter(property="confluence.endPoint", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @Parameter(property="confluence.spaceKey", required=true)
    private String spaceKey;
    @Parameter(property="confluence.parentPage", defaultValue="Home")
    private String parentPageTitle;
    @Parameter(property="confluence.userName", required=false)
    private String username;
    @Parameter(property="confluence.password", required=false)
    private String password;
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="confluence.serverId")
    private String serverId;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter
    protected SSLCertificateInfo sslCertificate = new SSLCertificateInfo();

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String getSpaceKey() {
        return this.spaceKey;
    }

    public final String getParentPageTitle() {
        return this.parentPageTitle;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    private void confluenceLogout(Confluence confluence) {
        if (null == confluence) {
            return;
        }
        try {
            if (!confluence.logout()) {
                this.getLog().warn((CharSequence)"confluence logout has failed!");
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"confluence logout has failed due exception ", (Throwable)e);
        }
    }

    protected void confluenceExecute(ConfluenceTask task) throws MojoExecutionException {
        if (this.sslCertificate != null) {
            this.getLog().debug((CharSequence)String.valueOf(this.sslCertificate));
            this.sslCertificate.setup(this);
        }
        Confluence confluence = null;
        try {
            Confluence.ProxyInfo proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new Confluence.ProxyInfo(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword(), activeProxy.getNonProxyHosts());
            }
            confluence = ConfluenceFactory.createInstanceDetectingVersion((String)this.getEndPoint(), proxyInfo, (String)this.getUsername(), (String)this.getPassword());
            this.getLog().info((CharSequence)ConfluenceUtils.getVersion((Confluence)confluence));
            task.execute(confluence);
            this.confluenceLogout(confluence);
        }
        catch (Exception e) {
            try {
                this.getLog().error((CharSequence)"has been imposssible connect to confluence due exception", (Throwable)e);
                throw new MojoExecutionException("has been imposssible connect to confluence due exception", e);
            }
            catch (Throwable throwable) {
                this.confluenceLogout(confluence);
                throw throwable;
            }
        }
    }

    protected static <T> T newClass(String clazz, Class<T> type) {
        try {
            Class<?> loadedClass = Thread.currentThread().getContextClassLoader().loadClass(clazz);
            Object initClass = loadedClass.newInstance();
            return type.cast(initClass);
        }
        catch (ClassNotFoundException e) {
            String msg = String.format("Could not found Class with name %s", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (InstantiationException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must be concrete.", clazz);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Could create Instance of Class with name %s. Class must have a no-arg constructor.", clazz);
            throw new IllegalStateException(msg, e);
        }
    }

    protected void loadUserInfoFromSettings() throws MojoExecutionException {
        if ((this.getUsername() == null || this.getPassword() == null) && this.mavenSettings != null) {
            if (this.serverId == null) {
                throw new MojoExecutionException("SettingKey must be set! (username and/or password are not provided)");
            }
            Server server = this.mavenSettings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("server with id [%s] not found in settings!", this.serverId));
            }
            if (this.getUsername() == null && server.getUsername() != null) {
                this.username = server.getUsername();
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                        ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                    }
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    protected static interface ConfluenceTask {
        public void execute(Confluence var1) throws Exception;
    }
}

