/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class PluginsRenderer
extends AbstractMavenReportRenderer {
    private final Log log;
    private final List plugins;
    private final List reports;
    private final Locale locale;
    private final I18N i18n;
    private final MavenProject project;
    private final MavenProjectBuilder mavenProjectBuilder;
    private final ArtifactFactory artifactFactory;
    private final ArtifactRepository localRepository;

    public PluginsRenderer(Log log, Sink sink, Locale locale, I18N i18n, Set plugins, Set reports, MavenProject project, MavenProjectBuilder mavenProjectBuilder, ArtifactFactory artifactFactory, ArtifactRepository localRepository) {
        super(sink);
        this.log = log;
        this.locale = locale;
        this.plugins = new ArrayList(plugins);
        this.reports = new ArrayList(reports);
        this.i18n = i18n;
        this.project = project;
        this.mavenProjectBuilder = mavenProjectBuilder;
        this.artifactFactory = artifactFactory;
        this.localRepository = localRepository;
    }

    public String getTitle() {
        return this.getReportString("report.plugins.title");
    }

    public void renderBody() {
        this.renderSectionPlugins(true);
        this.renderSectionPlugins(false);
    }

    private void renderSectionPlugins(boolean isPlugins) {
        List list = isPlugins ? this.plugins : this.reports;
        String[] tableHeader = this.getPluginTableHeader();
        this.startSection(isPlugins ? this.getReportString("report.plugins.title") : this.getReportString("report.plugins.report.title"));
        if (list == null || list.isEmpty()) {
            this.paragraph(isPlugins ? this.getReportString("report.plugins.nolist") : this.getReportString("report.plugins.report.nolist"));
            this.endSection();
            return;
        }
        Collections.sort(list, this.getArtifactComparator());
        this.startTable();
        this.tableHeader(tableHeader);
        for (Artifact artifact : list) {
            VersionRange versionRange = StringUtils.isEmpty((String)artifact.getVersion()) ? VersionRange.createFromVersion((String)"RELEASE") : VersionRange.createFromVersion((String)artifact.getVersion());
            Artifact pluginArtifact = this.artifactFactory.createParentArtifact(artifact.getGroupId(), artifact.getArtifactId(), versionRange.toString());
            ArrayList artifactRepositories = this.project.getPluginArtifactRepositories();
            if (artifactRepositories == null) {
                artifactRepositories = new ArrayList();
            }
            try {
                MavenProject pluginProject = this.mavenProjectBuilder.buildFromRepository(pluginArtifact, artifactRepositories, this.localRepository);
                this.tableRow(this.getPluginRow(pluginProject.getGroupId(), pluginProject.getArtifactId(), pluginProject.getVersion(), pluginProject.getUrl()));
            }
            catch (ProjectBuildingException e) {
                this.log.info((CharSequence)("Could not build project for: " + artifact.getArtifactId() + ":" + e.getMessage()), (Throwable)e);
                this.tableRow(this.getPluginRow(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), null));
            }
        }
        this.endTable();
        this.endSection();
    }

    private String[] getPluginTableHeader() {
        String groupId = this.getReportString("report.dependencyManagement.column.groupId");
        String artifactId = this.getReportString("report.dependencyManagement.column.artifactId");
        String version = this.getReportString("report.dependencyManagement.column.version");
        return new String[]{groupId, artifactId, version};
    }

    private String[] getPluginRow(String groupId, String artifactId, String version, String link) {
        artifactId = ProjectInfoReportUtils.getArtifactIdCell((String)artifactId, (String)link);
        return new String[]{groupId, artifactId, version};
    }

    private Comparator getArtifactComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Artifact a1 = (Artifact)o1;
                Artifact a2 = (Artifact)o2;
                int result = a1.getGroupId().compareTo(a2.getGroupId());
                if (result == 0) {
                    result = a1.getArtifactId().compareTo(a2.getArtifactId());
                }
                return result;
            }
        };
    }

    private String getReportString(String key) {
        return this.i18n.getString("project-info-report", this.locale, key);
    }
}

