/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.reporting.renderer;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.maven.scm.provider.starteam.repository.StarteamScmProviderRepository;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.bsc.maven.reporting.sink.ConfluenceSink;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class ScmRenderer
extends AbstractMavenReportRenderer {
    private Model model;
    private I18N i18n;
    private Locale locale;
    private ScmManager scmManager;
    private String anonymousConnection;
    private String devConnection;
    private String checkoutDirectoryName;
    private String webAccessUrl;

    public ScmRenderer(ScmManager scmManager, Sink sink, Model model, I18N i18n, Locale locale, String checkoutDirName, String webAccessUrl, String anonymousConnection, String devConnection) {
        super(sink);
        this.scmManager = scmManager;
        this.model = model;
        this.i18n = i18n;
        this.locale = locale;
        this.checkoutDirectoryName = checkoutDirName;
        this.webAccessUrl = webAccessUrl;
        this.anonymousConnection = anonymousConnection;
        this.devConnection = devConnection;
    }

    public String getTitle() {
        return this.i18n.getString("project-info-report", this.locale, "report.scm.title");
    }

    public void renderBody() {
        Scm scm = this.model.getScm();
        if (scm == null) {
            this.startSection(this.getTitle());
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.noscm"));
            this.endSection();
            return;
        }
        if (StringUtils.isEmpty((String)this.anonymousConnection) && StringUtils.isEmpty((String)this.devConnection) && StringUtils.isEmpty((String)scm.getUrl())) {
            this.startSection(this.getTitle());
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.noscm"));
            this.endSection();
            return;
        }
        ScmRepository anonymousRepository = this.getScmRepository(this.anonymousConnection);
        ScmRepository devRepository = this.getScmRepository(this.devConnection);
        this.startSection(this.getTitle());
        this.renderOverViewSection(anonymousRepository);
        this.renderWebAccesSection(this.webAccessUrl);
        this.renderAnonymousAccessSection(anonymousRepository);
        this.renderDeveloperAccessSection(devRepository);
        this.renderAccessBehindFirewallSection(devRepository);
        this.renderAccessThroughProxySection(anonymousRepository, devRepository);
        this.endSection();
    }

    private void renderOverViewSection(ScmRepository anonymousRepository) {
        this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.overview.title"));
        if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.clearcase.intro"));
        } else if (ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.cvs.intro"));
        } else if (ScmRenderer.isScmSystem(anonymousRepository, "perforce")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.perforce.intro"));
        } else if (ScmRenderer.isScmSystem(anonymousRepository, "starteam")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.starteam.intro"));
        } else if (ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.svn.intro"));
        } else {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.general.intro"));
        }
        this.sink.lineBreak();
        this.endSection();
    }

    private void renderWebAccesSection(String scmUrl) {
        this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.title"));
        if (StringUtils.isEmpty((String)scmUrl)) {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.nourl"));
        } else {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.webaccess.url"));
            this.verbatimLink(scmUrl, scmUrl);
        }
        this.endSection();
    }

    private void renderAnonymousAccessSection(ScmRepository anonymousRepository) {
        if (ScmRenderer.isScmSystem(anonymousRepository, "clearcase") || ScmRenderer.isScmSystem(anonymousRepository, "perforce") || ScmRenderer.isScmSystem(anonymousRepository, "starteam") || StringUtils.isEmpty((String)this.anonymousConnection)) {
            return;
        }
        this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.title"));
        if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "cvs")) {
            CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)anonymousRepository.getProviderRepository();
            this.anonymousAccessCVS(cvsRepo);
        } else if (anonymousRepository != null && ScmRenderer.isScmSystem(anonymousRepository, "svn")) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)anonymousRepository.getProviderRepository();
            this.anonymousAccessSVN(svnRepo);
        } else {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.general.intro"));
            if (this.anonymousConnection.length() < 4) {
                throw new IllegalArgumentException("The source repository connection is too short.");
            }
            this.verbatimText(this.anonymousConnection.substring(4));
        }
        this.endSection();
    }

    private void renderDeveloperAccessSection(ScmRepository devRepository) {
        if (StringUtils.isEmpty((String)this.devConnection)) {
            return;
        }
        this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.title"));
        if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "clearcase")) {
            this.developerAccessClearCase();
        } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
            CvsScmProviderRepository cvsRepo = (CvsScmProviderRepository)devRepository.getProviderRepository();
            this.developerAccessCVS(cvsRepo);
        } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "perforce")) {
            PerforceScmProviderRepository perforceRepo = (PerforceScmProviderRepository)devRepository.getProviderRepository();
            this.developerAccessPerforce(perforceRepo);
        } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "starteam")) {
            StarteamScmProviderRepository starteamRepo = (StarteamScmProviderRepository)devRepository.getProviderRepository();
            this.developerAccessStarteam(starteamRepo);
        } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
            this.developerAccessSVN(svnRepo);
        } else {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.general.intro"));
            if (this.devConnection.length() < 4) {
                throw new IllegalArgumentException("The source repository connection is too short.");
            }
            this.verbatimText(this.devConnection.substring(4));
        }
        this.endSection();
    }

    private void renderAccessBehindFirewallSection(ScmRepository devRepository) {
        this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.title"));
        if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "svn")) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)devRepository.getProviderRepository();
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.svn.intro"));
            StringBuffer sb = new StringBuffer();
            sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
            this.verbatimText(sb.toString());
        } else if (devRepository != null && ScmRenderer.isScmSystem(devRepository, "cvs")) {
            this.linkPatternedText(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.cvs.intro"));
        } else {
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessbehindfirewall.general.intro"));
        }
        this.endSection();
    }

    private void renderAccessThroughProxySection(ScmRepository anonymousRepository, ScmRepository devRepository) {
        if (ScmRenderer.isScmSystem(anonymousRepository, "svn") || ScmRenderer.isScmSystem(devRepository, "svn")) {
            this.startSection(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.title"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro1"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro2"));
            this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.accessthroughtproxy.svn.intro3"));
            StringBuffer sb = new StringBuffer();
            sb.append("[global]");
            sb.append("\n");
            sb.append("http-proxy-host = your.proxy.name").append("\n");
            sb.append("http-proxy-port = 3128").append("\n");
            this.verbatimText(sb.toString());
            this.endSection();
        }
    }

    private void developerAccessClearCase() {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.clearcase.intro"));
        StringBuffer command = new StringBuffer();
        command.append("$ cleartool checkout ");
        this.verbatimText(command.toString());
    }

    private void anonymousAccessCVS(CvsScmProviderRepository cvsRepo) {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.cvs.intro"));
        StringBuffer command = new StringBuffer();
        command.append("$ cvs -d ").append(cvsRepo.getCvsRoot()).append(" login");
        command.append("\n");
        command.append("$ cvs -z3 -d ").append(cvsRepo.getCvsRoot());
        command.append(" co ").append(cvsRepo.getModule());
        this.verbatimText(command.toString());
    }

    private void developerAccessCVS(CvsScmProviderRepository cvsRepo) {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.cvs.intro"));
        String cvsRoot = StringUtils.replace((String)cvsRepo.getCvsRoot(), (String)cvsRepo.getUser(), (String)"username");
        StringBuffer command = new StringBuffer();
        command.append("$ cvs -d ").append(cvsRoot).append(" login");
        command.append("\n");
        command.append("$ cvs -z3 -d ").append(cvsRoot).append(" co ").append(cvsRepo.getModule());
        this.verbatimText(command.toString());
    }

    private void developerAccessPerforce(PerforceScmProviderRepository perforceRepo) {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.perforce.intro"));
        StringBuffer command = new StringBuffer();
        command.append("$ p4");
        if (!StringUtils.isEmpty((String)perforceRepo.getHost())) {
            command.append(" -H ").append(perforceRepo.getHost());
        }
        if (perforceRepo.getPort() > 0) {
            command.append(" -p ").append(perforceRepo.getPort());
        }
        command.append(" -u username");
        command.append(" -P password");
        command.append(" ");
        command.append(perforceRepo.getPath());
        command.append("\n");
        command.append("$ p4 submit -c \"A comment\"");
        this.verbatimText(command.toString());
    }

    private void developerAccessStarteam(StarteamScmProviderRepository starteamRepo) {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.starteam.intro"));
        StringBuffer command = new StringBuffer();
        String fullUrl = StringUtils.replace((String)starteamRepo.getFullUrl(), (String)starteamRepo.getUser(), (String)"username");
        fullUrl = StringUtils.replace((String)fullUrl, (String)starteamRepo.getPassword(), (String)"password");
        command.append("$ stcmd co -x -nologo -stop -p ");
        command.append(fullUrl);
        command.append(" -is");
        command.append("\n");
        command.append("$ stcmd ci -x -nologo -stop -p ");
        command.append(fullUrl);
        command.append(" -f NCI -is");
        this.verbatimText(command.toString());
    }

    private void anonymousAccessSVN(SvnScmProviderRepository svnRepo) {
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.anonymousaccess.svn.intro"));
        StringBuffer sb = new StringBuffer();
        sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
        this.verbatimText(sb.toString());
    }

    private void developerAccessSVN(SvnScmProviderRepository svnRepo) {
        if (svnRepo.getUrl() != null) {
            if (svnRepo.getUrl().startsWith("https://")) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.https"));
            } else if (svnRepo.getUrl().startsWith("svn://")) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.svn"));
            } else if (svnRepo.getUrl().startsWith("svn+ssh://")) {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.svnssh"));
            } else {
                this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro1.other"));
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("$ svn checkout ").append(svnRepo.getUrl()).append(" ").append(this.checkoutDirectoryName);
        this.verbatimText(sb.toString());
        this.paragraph(this.i18n.getString("project-info-report", this.locale, "report.scm.devaccess.svn.intro2"));
        sb = new StringBuffer();
        sb.append("$ svn commit --username your-username -m \"A message\"");
        this.verbatimText(sb.toString());
    }

    public ScmRepository getScmRepository(String scmUrl) {
        ScmRepository repo = null;
        if (!StringUtils.isEmpty((String)scmUrl)) {
            try {
                repo = this.scmManager.makeScmRepository(scmUrl);
            }
            catch (NoSuchScmProviderException noSuchScmProviderException) {
            }
            catch (ScmRepositoryException scmRepositoryException) {
                // empty catch block
            }
        }
        return repo;
    }

    private static boolean isScmSystem(ScmRepository scmRepository, String scmProvider) {
        if (StringUtils.isEmpty((String)scmProvider)) {
            return false;
        }
        return scmRepository != null && scmProvider.equalsIgnoreCase(scmRepository.getProvider());
    }

    protected void verbatimLink(final String text, final String href) {
        ConfluenceSink.pushCommandBlock(this.sink, ConfluenceSink.Command.PANEL, new Runnable(){

            @Override
            public void run() {
                ScmRenderer.super.verbatimLink(text, href);
            }
        });
    }
}

