/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteFactory;
import org.bsc.maven.confluence.plugin.AbstractConfluenceMojo;

public abstract class AbstractConfluenceSiteMojo
extends AbstractConfluenceMojo
implements SiteFactory {
    @Parameter(defaultValue="${basedir}/src/site/confluence/site.xml")
    protected File siteDescriptor;

    public File getSiteDescriptor() {
        return this.siteDescriptor;
    }

    protected boolean isSiteDescriptorValid() {
        return this.siteDescriptor != null && this.siteDescriptor.exists() && this.siteDescriptor.isFile();
    }

    private void setPageUriFormFile(Site.Page page, File source) {
        if (page == null) {
            throw new IllegalArgumentException("page is null!");
        }
        if (source != null && source.exists() && source.isFile() && source.canRead()) {
            page.setUri(source.toURI());
        } else {
            try {
                URL sourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("defaultTemplate.confluence");
                page.setUri(sourceUrl.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateAttachments(Site.Page page, ConfluenceService confluence, ConfluenceService.Model.Page confluencePage) {
        this.getLog().info((CharSequence)String.format("generateAttachments pageId [%s] title [%s]", confluencePage.getId(), confluencePage.getTitle()));
        Iterator iterator = page.getAttachments().iterator();
        while (true) {
            ConfluenceService.Model.Attachment confluenceAttachment;
            Site.Attachment attachment;
            block20: {
                block21: {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    attachment = (Site.Attachment)iterator.next();
                    confluenceAttachment = null;
                    try {
                        confluenceAttachment = confluence.getAttachment(confluencePage.getId(), attachment.getName(), attachment.getVersion());
                    }
                    catch (Exception e) {
                        this.getLog().debug((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", attachment.getName(), e.getMessage()));
                    }
                    if (confluenceAttachment == null) break block21;
                    Date date = confluenceAttachment.getCreated();
                    if (date == null) {
                        this.getLog().warn((CharSequence)String.format("creation date of attachments [%s] is undefined. It will be replaced! ", confluenceAttachment.getFileName()));
                        break block20;
                    } else if (attachment.hasBeenUpdatedFrom(date)) {
                        this.getLog().info((CharSequence)String.format("attachment [%s] is more recent than the remote one. It will be replaced! ", confluenceAttachment.getFileName()));
                        break block20;
                    } else {
                        this.getLog().info((CharSequence)String.format("attachment [%s] skipped! no updated detected", confluenceAttachment.getFileName()));
                        continue;
                    }
                }
                this.getLog().info((CharSequence)String.format("Creating new attachment for [%s]", attachment.getName()));
                confluenceAttachment = confluence.createAttachment();
                confluenceAttachment.setFileName(attachment.getName());
                confluenceAttachment.setContentType(attachment.getContentType());
            }
            confluenceAttachment.setComment(attachment.getComment());
            try {
                InputStream is = attachment.getUri().toURL().openStream();
                Throwable throwable = null;
                try {
                    confluence.addAttchment(confluencePage, confluenceAttachment, is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                String msg = String.format("Error uploading attachment [%s] ", attachment.getName());
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected void generateChildren(ConfluenceService confluence, Site.Page parentPage, ConfluenceService.Model.Page confluenceParentPage, String titlePrefix, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
        this.getLog().info((CharSequence)String.format("generateChildren # [%d]", parentPage.getChildren().size()));
        this.generateAttachments(parentPage, confluence, confluenceParentPage);
        for (Site.Page child : parentPage.getChildren()) {
            ConfluenceService.Model.Page confluencePage = this.generateChild(confluence, child, confluenceParentPage.getSpace(), parentPage.getName(), titlePrefix);
            for (Site.Page.Generated generated : child.getGenerateds()) {
                varsToParentPageMap.put(generated.getRef(), confluencePage);
            }
            if (confluencePage == null) continue;
            this.generateChildren(confluence, child, confluencePage, titlePrefix, varsToParentPageMap);
        }
    }

    protected boolean navigateAttachments(File folder, Site.Page page) {
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isDirectory() || f.isHidden()) continue;
                    Site.Attachment a = new Site.Attachment();
                    a.setName(f.getName());
                    a.setUri(f.toURI());
                    page.getAttachments().add(a);
                }
            }
            return true;
        }
        return false;
    }

    protected void navigateChild(final int level, File folder, final Site.Page parentChild) {
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        if (AbstractConfluenceSiteMojo.this.navigateAttachments(file, parentChild)) {
                            return false;
                        }
                        Site.Page child = new Site.Page();
                        child.setName(file.getName());
                        AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, new File(file, AbstractConfluenceSiteMojo.this.templateWiki.getName()));
                        parentChild.getChildren().add(child);
                        AbstractConfluenceSiteMojo.this.navigateChild(level + 1, file, child);
                        return true;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceSiteMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceSiteMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceSiteMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, file);
                    parentChild.getChildren().add(child);
                    return false;
                }
            });
        }
    }

    public Site createFromFolder() {
        final Site result = new Site();
        result.getLabels().addAll(super.getLabels());
        Site.Page home = new Site.Page();
        home.setName(this.getTitle());
        this.setPageUriFormFile(home, this.templateWiki);
        result.setHome(home);
        this.navigateAttachments(this.getAttachmentFolder(), home);
        if (this.getChildrenFolder().exists() && this.getChildrenFolder().isDirectory()) {
            this.getChildrenFolder().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Site.Page parentChild = new Site.Page();
                        parentChild.setName(file.getName());
                        AbstractConfluenceSiteMojo.this.setPageUriFormFile(parentChild, new File(file, AbstractConfluenceSiteMojo.this.templateWiki.getName()));
                        result.getHome().getChildren().add(parentChild);
                        AbstractConfluenceSiteMojo.this.navigateChild(1, file, parentChild);
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceSiteMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceSiteMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceSiteMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, file);
                    result.getHome().getChildren().add(child);
                    return false;
                }
            });
        }
        return result;
    }

    public Site createFromModel() {
        Site site = null;
        if (!this.isSiteDescriptorValid()) {
            this.getLog().warn((CharSequence)"siteDescriptor is not valid!");
        } else {
            try {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Site.class});
                Unmarshaller unmarshaller = jc.createUnmarshaller();
                site = (Site)unmarshaller.unmarshal(this.siteDescriptor);
            }
            catch (JAXBException ex) {
                this.getLog().error((CharSequence)"error creating site from model!", (Throwable)ex);
            }
        }
        return site;
    }
}

