/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;

public class ConfluenceWikiWriter
extends PrintWriter {
    public ConfluenceWikiWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public ConfluenceWikiWriter(Writer out) {
        super(out);
    }

    public void printBiggestHeading(String value) {
        super.printf("h1. %s\n", value);
    }

    public ConfluenceWikiWriter appendBiggerHeading() {
        this.append("h2. ");
        return this;
    }

    public ConfluenceWikiWriter appendBigHeading() {
        this.append("h3. ");
        return this;
    }

    public void printInfo(String title, String value) {
        this.printf("{info:title=%s}\n%s\n{info}", title, value);
        this.println();
    }

    public void printBiggerHeading(String value) {
        super.printf("h2. %s\n", value);
    }

    public void printBigHeading(String value) {
        super.printf("h3. %s\n", value);
    }

    public void printNormalHeading(String value) {
        super.printf("h4. %s\n", value);
    }

    public void printSmallHeading(String value) {
        super.printf("h5. %s\n", value);
    }

    public void printSmallestHeading(String value) {
        super.printf("h6. %s\n", value);
    }

    public ConfluenceWikiWriter appendBullet() {
        this.append("* ");
        return this;
    }

    public void printBullet(String value) {
        this.printBullets(1, value);
    }

    public void printQuote(String value) {
        this.println("{quote}");
        this.println(value);
        this.println("{quote}");
    }

    public void printNewParagraph() {
        this.println();
    }

    public void printLineBreak() {
        this.println("\\\\");
    }

    public void printStrong(String value) {
        super.printf("*%s*\n", value);
    }

    public void printBullets(int depth, String value) {
        for (int i = 0; i < depth; ++i) {
            this.append('*');
        }
        this.append(' ').append(value).append('\n');
    }

    public void printLinkToAnchor(String anchorName, String value) {
        this.printf("[%s|#%s]\n", value, anchorName);
    }

    public void printLink(String link, String value) {
        this.printf("[%s|%s]\n", value, link);
    }

    public ConfluenceWikiWriter appendAnchor(String anchorName, String value) {
        this.printAnchor(anchorName, value);
        return this;
    }

    public void printAnchor(String anchorName, String value) {
        this.printf(ConfluenceWikiWriter.createAnchor(anchorName, value), new Object[0]);
    }

    static String createLinkToAnchor(String anchorName, String value) {
        return String.format("[%s|#%s]", value, anchorName);
    }

    static String createAnchor(String anchorName, String value) {
        return String.format("{anchor:%s}%s", anchorName, value);
    }
}

