/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import com.github.qwazer.mavenplugins.gitlog.CalculateRuleForSinceTagName;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.maven.confluence.plugin.AbstractConfluenceSiteMojo;
import org.bsc.maven.confluence.plugin.PluginConfluenceDocGenerator;
import org.bsc.maven.confluence.plugin.ReportingResolutionListener;
import org.bsc.maven.reporting.renderer.DependenciesRenderer;
import org.bsc.maven.reporting.renderer.GitLogJiraIssuesRenderer;
import org.bsc.maven.reporting.renderer.ProjectSummaryRenderer;
import org.bsc.maven.reporting.renderer.ProjectTeamRenderer;
import org.bsc.maven.reporting.renderer.ScmRenderer;
import org.bsc.maven.reporting.sink.ConfluenceSink;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.i18n.I18N;
import rx.functions.Action1;
import rx.functions.Func2;

@Mojo(name="deploy", threadSafe=true)
public class ConfluenceDeployMojo
extends AbstractConfluenceSiteMojo {
    private static final String PROJECT_DEPENDENCIES_VAR = "project.dependencies";
    private static final String PROJECT_SCM_MANAGER_VAR = "project.scmManager";
    private static final String PROJECT_TEAM_VAR = "project.team";
    private static final String PROJECT_SUMMARY_VAR = "project.summary";
    private static final String GITLOG_JIRA_ISSUES_VAR = "gitlog.jiraIssues";
    private static final String GITLOG_SINCE_TAG_NAME = "gitlog.sinceTagName";
    public static final String PLUGIN_SUMMARY_VAR = "plugin.summary";
    public static final String PLUGIN_GOALS_VAR = "plugin.goals";
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector collector;
    @Component(role=ArtifactFactory.class)
    protected ArtifactFactory factory;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected I18N i18n;
    @Parameter(property="project.build.directory/generated-site/confluence", required=true)
    protected File outputDirectory;
    @Component(role=ScmManager.class)
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;
    @Parameter(defaultValue="false")
    private Boolean gitLogJiraIssuesEnable;
    @Parameter(defaultValue="")
    private String gitLogSinceTagName;
    @Parameter(defaultValue="")
    private String gitLogUntilTagName;
    @Parameter(defaultValue="NO_RULE")
    private CalculateRuleForSinceTagName gitLogCalculateRuleForSinceTagName;
    @Parameter(defaultValue="")
    private List<String> gitLogJiraProjectKeyList;
    @Parameter(defaultValue="")
    private String gitLogTagNamesPattern;
    @Parameter(defaultValue="false")
    private Boolean gitLogGroupByVersions;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepos;
    @Component
    protected MojoScanner mojoScanner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Locale locale = Locale.getDefault();
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        this.loadUserInfoFromSettings();
        Site site = null;
        if (this.isSiteDescriptorValid()) {
            site = super.createFromModel();
        }
        if (site != null) {
            site.setBasedir(this.getSiteDescriptor());
            if (site.getHome().getName() != null) {
                this.setTitle(site.getHome().getName());
            } else {
                site.getHome().setName(this.getTitle());
            }
            List<String> _labels = this.getLabels();
            if (!_labels.isEmpty()) {
                site.getLabels().addAll(_labels);
            }
        } else {
            site = super.createFromFolder();
        }
        site.print(System.out);
        super.initTemplateProperties();
        try {
            if (this.project.getPackaging().equals("maven-plugin")) {
                this.generatePluginReport(site, locale);
            } else {
                this.generateProjectReport(site, locale);
            }
        }
        catch (MojoExecutionException e) {
            String msg = "error generating report";
            if (this.isFailOnError()) {
                throw e;
            }
            this.getLog().error((CharSequence)"error generating report", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "error generating report";
            Throwable cause = e.getCause();
            if (this.isFailOnError()) {
                throw new MojoExecutionException("error generating report", cause != null ? cause : e);
            }
            this.getLog().error((CharSequence)"error generating report", cause != null ? cause : e);
        }
    }

    protected void generateProjectHomeTemplate(MiniTemplator t, Site site, Locale locale) throws MojoExecutionException {
        if (t == null) {
            throw new IllegalArgumentException("templator is null!");
        }
        super.addStdProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w);
        ProjectSummaryRenderer summary = new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale);
        summary.render();
        try {
            String project_summary_var = w.toString();
            this.getProperties().put(PROJECT_SUMMARY_VAR, project_summary_var);
            t.setVariable(PROJECT_SUMMARY_VAR, project_summary_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        ProjectTeamRenderer renderer = new ProjectTeamRenderer((Sink)sink, this.project.getModel(), this.i18n, locale, this.getLog(), false);
        renderer.render();
        try {
            String project_team_var = w.toString();
            this.getProperties().put(PROJECT_TEAM_VAR, project_team_var);
            t.setVariable(PROJECT_TEAM_VAR, project_team_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_TEAM_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        String scmTag = "";
        new ScmRenderer(this.getLog(), this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection, "").render();
        try {
            String project_scm_var = w.toString();
            this.getProperties().put(PROJECT_SCM_MANAGER_VAR, project_scm_var);
            t.setVariable(PROJECT_SCM_MANAGER_VAR, project_scm_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            String project_dependencies_var = w.toString();
            this.getProperties().put(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
            t.setVariable(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        if (this.gitLogJiraIssuesEnable.booleanValue()) {
            w = new StringWriter(10240);
            sink = new ConfluenceSink(w);
            String currentVersion = this.project.getVersion();
            GitLogJiraIssuesRenderer gitLogJiraIssuesRenderer = new GitLogJiraIssuesRenderer((Sink)sink, this.gitLogSinceTagName, this.gitLogUntilTagName, this.gitLogJiraProjectKeyList, currentVersion, this.gitLogCalculateRuleForSinceTagName, this.gitLogTagNamesPattern, this.gitLogGroupByVersions, this.getLog());
            gitLogJiraIssuesRenderer.render();
            this.gitLogSinceTagName = gitLogJiraIssuesRenderer.getGitLogSinceTagName();
            try {
                String gitlog_jiraissues_var = w.toString();
                this.getProperties().put(GITLOG_JIRA_ISSUES_VAR, gitlog_jiraissues_var);
                t.setVariable(GITLOG_JIRA_ISSUES_VAR, gitlog_jiraissues_var);
            }
            catch (MiniTemplator.VariableNotDefinedException e) {
                this.getLog().debug((CharSequence)String.format("variable %s not defined in template", GITLOG_JIRA_ISSUES_VAR));
            }
            try {
                if (this.gitLogSinceTagName == null) {
                    this.gitLogSinceTagName = "beginning of gitlog";
                }
                this.getProperties().put(GITLOG_SINCE_TAG_NAME, this.gitLogSinceTagName);
                t.setVariable(GITLOG_SINCE_TAG_NAME, this.gitLogSinceTagName);
            }
            catch (MiniTemplator.VariableNotDefinedException e) {
                this.getLog().debug((CharSequence)String.format("variable %s not defined in template", GITLOG_SINCE_TAG_NAME));
            }
        }
    }

    private void generateProjectReport(final ConfluenceService confluence, final Site site, final Locale locale) throws Exception {
        final ConfluenceService.Model.Page parentPage = this.loadParentPage(confluence);
        final String title = this.getTitle();
        if (!this.isSnapshot() && this.isRemoveSnapshots()) {
            String snapshot = title.concat("-SNAPSHOT");
            this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
            boolean deleted = confluence.removePage(parentPage, snapshot);
            if (deleted) {
                this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
            }
        }
        String titlePrefix = title;
        ConfluenceService.Model.Page confluenceHomePage = (ConfluenceService.Model.Page)Site.processUri((URI)site.getHome().getUri(), (String)this.getTitle(), (Func2)new Func2<InputStream, ConfluenceService.Storage.Representation, ConfluenceService.Model.Page>(){

            public ConfluenceService.Model.Page call(InputStream is, ConfluenceService.Storage.Representation r) {
                try {
                    ConfluenceService.Model.Page page = confluence.getOrCreatePage(parentPage.getSpace(), parentPage.getTitle(), title);
                    MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(is, ConfluenceDeployMojo.this.getCharset());
                    ConfluenceDeployMojo.this.generateProjectHomeTemplate(t, site, locale);
                    return confluence.storePage(page, new ConfluenceService.Storage(t.generateOutput(), r));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        for (String label : site.getHome().getComputedLabels()) {
            confluence.addLabelByName(label, Long.parseLong(confluenceHomePage.getId()));
        }
        this.generateChildren(confluence, site.getHome(), confluenceHomePage, titlePrefix, new HashMap<String, ConfluenceService.Model.Page>());
    }

    private void generateProjectReport(final Site site, final Locale locale) throws MojoExecutionException {
        super.confluenceExecute(new Action1<ConfluenceService>(){

            public void call(ConfluenceService confluence) {
                try {
                    ConfluenceDeployMojo.this.generateProjectReport(confluence, site, locale);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    private ReportingResolutionListener resolveProject() {
        Map managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportingResolutionListener listener = new ReportingResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        HashMap<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.EMPTY_MAP;
        }
        return map;
    }

    public String getDescription(Locale locale) {
        return "confluence";
    }

    public String getOutputName() {
        return "confluence";
    }

    public String getName(Locale locale) {
        return "confluence";
    }

    private static List<ComponentDependency> toComponentDependencies(List<Dependency> dependencies) {
        return GeneratorUtils.toComponentDependencies(dependencies);
    }

    private void generatePluginReport(final Site site, final Locale locale) throws MojoExecutionException {
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        final PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        ArrayList<ComponentDependency> deps = new ArrayList<ComponentDependency>();
        deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getRuntimeDependencies()));
        deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getCompileDependencies()));
        pluginDescriptor.setDependencies(deps);
        pluginDescriptor.setDescription(this.project.getDescription());
        DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
        request.setEncoding(this.getEncoding());
        request.setLocal(this.local);
        request.setRemoteRepos(this.remoteRepos);
        request.setSkipErrorNoDescriptorsFound(false);
        request.setDependencies(this.dependencies);
        try {
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)request);
        }
        catch (InvalidPluginDescriptorException e) {
            this.getLog().warn((CharSequence)String.format("Plugin without mojos. %s\nMojoScanner:%s", e.getMessage(), this.mojoScanner.getClass()));
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException(String.format("Error extracting plugin descriptor: %s", e.getLocalizedMessage()), (Exception)((Object)e));
        }
        super.confluenceExecute(new Action1<ConfluenceService>(){

            public void call(ConfluenceService confluence) {
                try {
                    ConfluenceService.Model.Page parentPage = ConfluenceDeployMojo.this.loadParentPage(confluence);
                    ConfluenceDeployMojo.this.outputDirectory.mkdirs();
                    ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("speceKey=%s parentPageTitle=%s", parentPage.getSpace(), parentPage.getTitle()));
                    PluginGenerator generator = new PluginGenerator();
                    DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(ConfluenceDeployMojo.this.project, pluginDescriptor);
                    ConfluenceService.Model.Page confluenceHomePage = generator.processMojoDescriptors(request.getPluginDescriptor(), confluence, parentPage, site, locale);
                    for (String label : site.getHome().getComputedLabels()) {
                        confluence.addLabelByName(label, Long.parseLong(confluenceHomePage.getId()));
                    }
                    String title = ConfluenceDeployMojo.this.getTitle();
                    HashMap<String, ConfluenceService.Model.Page> varsToParentPageMap = new HashMap<String, ConfluenceService.Model.Page>();
                    ConfluenceDeployMojo.this.generateChildren(confluence, site.getHome(), confluenceHomePage, title, varsToParentPageMap);
                    generator.generateGoalsPages(confluence, confluenceHomePage, varsToParentPageMap);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    class PluginGenerator
    extends PluginConfluenceDocGenerator {
        final List<PluginConfluenceDocGenerator.Goal> goals = new ArrayList<PluginConfluenceDocGenerator.Goal>();

        PluginGenerator() {
        }

        void generateGoalsPages(ConfluenceService confluence, ConfluenceService.Model.Page confluenceHome, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
            ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Get the right page to generate the %s pages under", ConfluenceDeployMojo.PLUGIN_GOALS_VAR));
            ConfluenceService.Model.Page goalsParentPage = confluenceHome;
            if (varsToParentPageMap.containsKey(ConfluenceDeployMojo.PLUGIN_GOALS_VAR)) {
                goalsParentPage = varsToParentPageMap.get(ConfluenceDeployMojo.PLUGIN_GOALS_VAR);
            }
            ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Plugin Goals parentPage is: %s", goalsParentPage.getTitle()));
            for (PluginConfluenceDocGenerator.Goal goal : this.goals) {
                try {
                    ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("- generating: %s", goal.getPageName(confluenceHome.getTitle())));
                    goal.generatePage(confluence, goalsParentPage, confluenceHome.getTitle());
                }
                catch (Exception ex) {
                    ConfluenceDeployMojo.this.getLog().warn((CharSequence)String.format("error generatig page for goal [%s]", goal.descriptor.getGoal()), (Throwable)ex);
                }
            }
        }

        public ConfluenceService.Model.Page processMojoDescriptors(final PluginDescriptor pluginDescriptor, final ConfluenceService confluence, final ConfluenceService.Model.Page parentPage, final Site site, final Locale locale) throws Exception {
            final List mojos = pluginDescriptor.getMojos();
            if (mojos == null) {
                ConfluenceDeployMojo.this.getLog().warn((CharSequence)"no mojos found [pluginDescriptor.getMojos()]");
            } else if (ConfluenceDeployMojo.this.getLog().isDebugEnabled()) {
                ConfluenceDeployMojo.this.getLog().debug((CharSequence)"Found the following Mojos:");
                for (MojoDescriptor mojo : mojos) {
                    ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("  - %s : %s", mojo.getFullGoalName(), mojo.getDescription()));
                }
            }
            final String title = ConfluenceDeployMojo.this.getTitle();
            ConfluenceDeployMojo.this.getProperties().put("pageTitle", title);
            ConfluenceDeployMojo.this.getProperties().put("artifactId", ConfluenceDeployMojo.this.getProject().getArtifactId());
            ConfluenceDeployMojo.this.getProperties().put("version", ConfluenceDeployMojo.this.getProject().getVersion());
            return (ConfluenceService.Model.Page)Site.processUri((URI)site.getHome().getUri(), (String)ConfluenceDeployMojo.this.getTitle(), (Func2)new Func2<InputStream, ConfluenceService.Storage.Representation, ConfluenceService.Model.Page>(){

                public ConfluenceService.Model.Page call(InputStream is, ConfluenceService.Storage.Representation sr) {
                    try {
                        MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(is, ConfluenceDeployMojo.this.getCharset());
                        ConfluenceService.Model.Page page = confluence.getOrCreatePage(parentPage, title);
                        if (!ConfluenceDeployMojo.this.isSnapshot() && ConfluenceDeployMojo.this.isRemoveSnapshots()) {
                            String snapshot = title.concat("-SNAPSHOT");
                            ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
                            boolean deleted = confluence.removePage(parentPage, snapshot);
                            if (deleted) {
                                ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
                            }
                        }
                        StringWriter writer = new StringWriter(102400);
                        PluginGenerator.this.writeSummary(writer, pluginDescriptor);
                        writer.flush();
                        try {
                            String summary = writer.toString();
                            ConfluenceDeployMojo.this.getProperties().put(ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, summary);
                            t.setVariable(ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, summary);
                        }
                        catch (MiniTemplator.VariableNotDefinedException e) {
                            ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("variable %s or %s not defined in template", ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, ConfluenceDeployMojo.PROJECT_SUMMARY_VAR));
                        }
                        ConfluenceDeployMojo.this.generateProjectHomeTemplate(t, site, locale);
                        writer = new StringWriter(102400);
                        PluginGenerator.this.goals.addAll(PluginGenerator.this.writeGoalsAsChildren(writer, title, mojos));
                        writer.flush();
                        try {
                            String plugin_goals = writer.toString();
                            ConfluenceDeployMojo.this.getProperties().put(ConfluenceDeployMojo.PLUGIN_GOALS_VAR, plugin_goals);
                            t.setVariable(ConfluenceDeployMojo.PLUGIN_GOALS_VAR, plugin_goals);
                        }
                        catch (MiniTemplator.VariableNotDefinedException e) {
                            ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("variable %s not defined in template", ConfluenceDeployMojo.PLUGIN_GOALS_VAR));
                        }
                        page = confluence.storePage(page, new ConfluenceService.Storage(t.generateOutput(), ConfluenceService.Storage.Representation.WIKI));
                        return page;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
        }
    }
}

