/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;
import rx.functions.Action1;

@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;

    private void deletePage(ConfluenceService confluence) throws Exception {
        ConfluenceService.Model.Page parentPage = this.loadParentPage(confluence);
        if (parentPage == null) {
            this.getLog().warn((CharSequence)String.format("Parent page [%s] in [%s] not found!", parentPage.getTitle(), parentPage.getSpace()));
            return;
        }
        ConfluenceService.Model.PageSummary root = confluence.findPageByTitle(parentPage.getId(), this.pageTitle);
        if (root == null) {
            this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", parentPage.getTitle(), this.pageTitle, parentPage.getSpace()));
            return;
        }
        if (this.recursive) {
            List descendents = confluence.getDescendents(root.getId());
            if (descendents == null || descendents.isEmpty()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", parentPage.getTitle(), this.pageTitle, parentPage.getSpace()));
            } else {
                for (ConfluenceService.Model.PageSummary descendent : descendents) {
                    this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s]  has been removed!", parentPage.getTitle(), this.pageTitle, descendent.getTitle()));
                    confluence.removePage(descendent.getId());
                }
            }
        }
        confluence.removePage(root.getId());
        this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), this.pageTitle, parentPage.getSpace()));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.loadUserInfoFromSettings();
        super.confluenceExecute(new Action1<ConfluenceService>(){

            public void call(ConfluenceService confluence) {
                try {
                    ConfluenceDeleteMojo.this.deletePage(confluence);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }
}

