/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceServiceFactory;
import org.bsc.ssl.SSLCertificateInfo;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import rx.functions.Action1;

public abstract class AbstractBaseConfluenceMojo
extends AbstractMojo {
    @Parameter
    private Map<String, String> properties;
    @Parameter(property="confluence.endPoint", defaultValue="http://localhost:8080/rpc/xmlrpc")
    private String endPoint;
    @Parameter(property="confluence.spaceKey", required=false)
    private String spaceKey;
    @Parameter(property="confluence.parentPage", defaultValue="Home")
    private String parentPageTitle;
    @Parameter(property="confluence.parentPageId")
    private String parentPageId;
    @Parameter(property="confluence.userName", required=false)
    private String username;
    @Parameter(property="confluence.password", required=false)
    private String password;
    @Parameter(readonly=true, property="settings")
    protected Settings mavenSettings;
    @Parameter(property="confluence.serverId")
    private String serverId;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter
    protected SSLCertificateInfo sslCertificate = new SSLCertificateInfo();
    @Parameter(property="confluence.failOnError", defaultValue="true")
    private boolean failOnError = true;

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public final String getEndPoint() {
        return this.endPoint;
    }

    public final String _getSpaceKey() {
        return this.spaceKey;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>(5);
        }
        return this.properties;
    }

    protected <T extends Action1<ConfluenceService>> void confluenceExecute(T task) throws MojoExecutionException {
        ConfluenceService confluence = null;
        try {
            ConfluenceProxy proxyInfo = null;
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                proxyInfo = new ConfluenceProxy(activeProxy.getHost(), activeProxy.getPort(), activeProxy.getUsername(), activeProxy.getPassword(), activeProxy.getNonProxyHosts());
            }
            ConfluenceService.Credentials credentials = new ConfluenceService.Credentials(this.getUsername(), this.getPassword());
            confluence = ConfluenceServiceFactory.createInstance((String)this.getEndPoint(), (ConfluenceService.Credentials)credentials, (ConfluenceProxy)proxyInfo, (SSLCertificateInfo)this.sslCertificate);
            this.getLog().info((CharSequence)String.valueOf(confluence));
            confluence.call(task);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            String msg = "has been impossible connect to confluence due exception";
            throw new MojoExecutionException("has been impossible connect to confluence due exception", e);
        }
    }

    protected ConfluenceService.Model.Page loadParentPage(ConfluenceService confluence) throws MojoExecutionException {
        ConfluenceService.Model.Page result = null;
        if (this.parentPageId != null) {
            try {
                result = confluence.getPage(this.parentPageId);
                if (result == null) {
                    this.getLog().warn((CharSequence)String.format("parentPageId [%s] not found! Try with parentPageTitle [%s] in space [%s]", this.parentPageId, this.parentPageTitle, this.spaceKey));
                }
            }
            catch (Exception ex) {
                this.getLog().warn((CharSequence)String.format("cannot get page with parentPageId [%s]! Try with parentPageTitle [%s] in space [%s]\n%s", this.parentPageId, this.parentPageTitle, this.spaceKey, ExceptionUtils.getRootCauseMessage((Throwable)ex)));
            }
        }
        if (result == null) {
            if (this.spaceKey == null) {
                throw new MojoExecutionException("spaceKey is not set!");
            }
            try {
                result = confluence.getPage(this.spaceKey, this.parentPageTitle);
                if (result == null) {
                    throw new MojoExecutionException(String.format("parentPageTitle [%s] not found in space [%s]!", this.parentPageTitle, this.spaceKey));
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException(String.format("cannot get page with parentPageTitle [%s] in space [%s]!", this.parentPageTitle, this.spaceKey), ex);
            }
        }
        this.getProperties().put("parentPageTitle", result.getTitle());
        return result;
    }

    protected void loadUserInfoFromSettings() throws MojoExecutionException {
        if ((this.getUsername() == null || this.getPassword() == null) && this.mavenSettings != null) {
            if (this.serverId == null) {
                throw new MojoExecutionException("SettingKey must be set! (username and/or password are not provided)");
            }
            Server server = this.mavenSettings.getServer(this.serverId);
            if (server == null) {
                throw new MojoExecutionException(String.format("server with id [%s] not found in settings!", this.serverId));
            }
            if (this.getUsername() == null && server.getUsername() != null) {
                this.username = server.getUsername();
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                        ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
                    }
                    this.password = this.securityDispatcher.decrypt(server.getPassword());
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }
}

