/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteFactory;
import org.bsc.confluence.model.SiteProcessor;
import org.bsc.maven.confluence.plugin.AbstractConfluenceMojo;

public abstract class AbstractConfluenceSiteMojo
extends AbstractConfluenceMojo
implements SiteFactory {
    @Parameter(defaultValue="${basedir}/src/site/confluence/site.xml")
    protected File siteDescriptor;

    public File getSiteDescriptor() {
        return this.siteDescriptor;
    }

    protected boolean isSiteDescriptorValid() {
        return this.siteDescriptor != null && this.siteDescriptor.exists() && this.siteDescriptor.isFile();
    }

    private void setPageUriFormFile(Site.Page page, File source) {
        if (page == null) {
            throw new IllegalArgumentException("page is null!");
        }
        if (source != null && source.exists() && source.isFile() && source.canRead()) {
            page.setUri(source.toURI());
        } else {
            try {
                URL sourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("defaultTemplate.confluence");
                page.setUri(sourceUrl.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private DirectoryStream<Path> newDirectoryStream(Path attachmentPath, Site.Attachment attachment) throws IOException {
        if (StringUtils.isNotBlank((String)attachment.getName())) {
            return Files.newDirectoryStream(attachmentPath, attachment.getName());
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory(entry, new LinkOption[0]) && !Files.isHidden(entry) && !Files.isSymbolicLink(entry) && Files.isReadable(entry);
            }
        };
        return Files.newDirectoryStream(attachmentPath, (DirectoryStream.Filter<? super Path>)filter);
    }

    private void generateAttachments(ConfluenceService confluence, Site site, Site.Page page, ConfluenceService.Model.Page confluencePage) {
        this.getLog().debug((CharSequence)String.format("generateAttachments pageId [%s] title [%s]", confluencePage.getId(), confluencePage.getTitle()));
        for (Site.Attachment attachment : page.getAttachments()) {
            Path attachmentPath = Paths.get(attachment.getUri());
            if (!Files.isDirectory(attachmentPath, new LinkOption[0])) {
                this.generateAttachment(confluence, site, confluencePage, attachment);
                continue;
            }
            try {
                DirectoryStream<Path> dirStream = this.newDirectoryStream(attachmentPath, attachment);
                Throwable throwable = null;
                try {
                    for (Path p : dirStream) {
                        Site.Attachment fileAttachment = new Site.Attachment();
                        fileAttachment.setName(p.getFileName().toString());
                        fileAttachment.setUri(p.toUri());
                        fileAttachment.setComment(attachment.getComment());
                        fileAttachment.setVersion(attachment.getVersion());
                        if (StringUtils.isNotEmpty((String)attachment.getContentType())) {
                            fileAttachment.setContentType(attachment.getContentType());
                        }
                        this.generateAttachment(confluence, site, confluencePage, fileAttachment);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dirStream == null) continue;
                    if (throwable != null) {
                        try {
                            dirStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dirStream.close();
                }
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)String.format("error reading directory [%s]", attachmentPath), (Throwable)ex);
            }
        }
    }

    private CompletableFuture<ConfluenceService.Model.Attachment> updateAttachmentData(ConfluenceService confluence, Site site, URI uri, ConfluenceService.Model.Page confluencePage, ConfluenceService.Model.Attachment attachment) {
        return (CompletableFuture)SiteProcessor.processUri((URI)uri, (err, is) -> {
            if (err.isPresent()) {
                CompletableFuture result = new CompletableFuture();
                result.completeExceptionally((Throwable)err.get());
                return result;
            }
            return is.isPresent() ? confluence.addAttachment(confluencePage, attachment, (InputStream)is.get()) : CompletableFuture.completedFuture(attachment);
        });
    }

    private void generateAttachment(ConfluenceService confluence, Site site, ConfluenceService.Model.Page confluencePage, Site.Attachment attachment) {
        this.getLog().debug((CharSequence)String.format("generateAttachment\n\tpageId:[%s]\n\ttitle:[%s]\n\tfile:[%s]", confluencePage.getId(), confluencePage.getTitle(), this.getPrintableStringForResource(attachment.getUri())));
        URI uri = attachment.getUri();
        ((CompletableFuture)((CompletableFuture)confluence.getAttachment(confluencePage.getId(), attachment.getName(), attachment.getVersion()).exceptionally(e -> {
            this.getLog().debug((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", attachment.getName(), e.getMessage()));
            return Optional.empty();
        })).thenCompose(att -> {
            if (!att.isPresent()) {
                this.getLog().debug((CharSequence)String.format("Creating new attachment for [%s]", attachment.getName()));
                ConfluenceService.Model.Attachment result = confluence.createAttachment();
                result.setFileName(attachment.getName());
                result.setContentType(attachment.getContentType());
                result.setComment(attachment.getComment());
                return this.resetUpdateStatusForResource(uri).thenCompose(reset -> CompletableFuture.completedFuture(result));
            }
            ConfluenceService.Model.Attachment result = (ConfluenceService.Model.Attachment)att.get();
            result.setContentType(attachment.getContentType());
            result.setComment(attachment.getComment());
            return CompletableFuture.completedFuture(result);
        })).thenCompose(finalAttachment -> this.canProceedToUpdateResource(uri).thenCompose(updated -> {
            if (updated.booleanValue()) {
                return this.updateAttachmentData(confluence, site, uri, confluencePage, (ConfluenceService.Model.Attachment)finalAttachment);
            }
            this.getLog().info((CharSequence)String.format("attachment [%s] has not been updated (deploy skipped)", this.getPrintableStringForResource(uri)));
            return CompletableFuture.completedFuture(finalAttachment);
        }));
    }

    protected void generateChildren(ConfluenceService confluence, Site site, Site.Page parentPage, ConfluenceService.Model.Page confluenceParentPage, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
        this.getLog().debug((CharSequence)String.format("generateChildren # [%d]", parentPage.getChildren().size()));
        this.generateAttachments(confluence, site, parentPage, confluenceParentPage);
        for (Site.Page child : parentPage.getChildren()) {
            ConfluenceService.Model.Page confluencePage = this.generateChild(confluence, site, child, confluenceParentPage);
            for (Site.Page.Generated generated : child.getGenerateds()) {
                varsToParentPageMap.put(generated.getRef(), confluencePage);
            }
            if (confluencePage == null) continue;
            this.generateChildren(confluence, site, child, confluencePage, varsToParentPageMap);
        }
    }

    protected boolean navigateAttachments(File folder, Site.Page page) {
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isDirectory() || f.isHidden()) continue;
                    Site.Attachment a = new Site.Attachment();
                    a.setName(f.getName());
                    a.setUri(f.toURI());
                    page.getAttachments().add(a);
                }
            }
            return true;
        }
        return false;
    }

    protected void navigateChild(final int level, File folder, final Site.Page parentChild) {
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        if (AbstractConfluenceSiteMojo.this.navigateAttachments(file, parentChild)) {
                            return false;
                        }
                        Site.Page child = new Site.Page();
                        child.setName(file.getName());
                        AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, new File(file, AbstractConfluenceSiteMojo.this.templateWiki.getName()));
                        parentChild.getChildren().add(child);
                        AbstractConfluenceSiteMojo.this.navigateChild(level + 1, file, child);
                        return true;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceSiteMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceSiteMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceSiteMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, file);
                    parentChild.getChildren().add(child);
                    return false;
                }
            });
        }
    }

    public Site createFromFolder() {
        final Site result = new Site();
        result.getLabels().addAll(super.getLabels());
        Site.Home home = new Site.Home();
        home.setName(this.getTitle());
        this.setPageUriFormFile((Site.Page)home, this.templateWiki);
        result.setHome(home);
        this.navigateAttachments(this.getAttachmentFolder(), (Site.Page)home);
        if (this.getChildrenFolder().exists() && this.getChildrenFolder().isDirectory()) {
            this.getChildrenFolder().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Site.Page parentChild = new Site.Page();
                        parentChild.setName(file.getName());
                        AbstractConfluenceSiteMojo.this.setPageUriFormFile(parentChild, new File(file, AbstractConfluenceSiteMojo.this.templateWiki.getName()));
                        result.getHome().getChildren().add(parentChild);
                        AbstractConfluenceSiteMojo.this.navigateChild(1, file, parentChild);
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceSiteMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceSiteMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceSiteMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceSiteMojo.this.setPageUriFormFile(child, file);
                    result.getHome().getChildren().add(child);
                    return false;
                }
            });
        }
        return result;
    }

    public Site createFromModel() {
        if (!this.isSiteDescriptorValid()) {
            this.getLog().warn((CharSequence)"siteDescriptor is not valid!");
            return null;
        }
        try {
            return this.createFrom(this.siteDescriptor);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"error creating site from model!", (Throwable)ex);
            return null;
        }
    }
}

