/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import com.github.qwazer.mavenplugins.gitlog.CalculateRuleForSinceTagName;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.generator.GeneratorUtils;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.DeployStateManager;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SitePrinter;
import org.bsc.confluence.model.SiteProcessor;
import org.bsc.functional.Tuple2;
import org.bsc.maven.confluence.plugin.AbstractConfluenceSiteMojo;
import org.bsc.maven.confluence.plugin.PluginConfluenceDocGenerator;
import org.bsc.maven.confluence.plugin.ReportingResolutionListener;
import org.bsc.maven.reporting.renderer.DependenciesRenderer;
import org.bsc.maven.reporting.renderer.GitLogJiraIssuesRenderer;
import org.bsc.maven.reporting.renderer.ProjectSummaryRenderer;
import org.bsc.maven.reporting.renderer.ProjectTeamRenderer;
import org.bsc.maven.reporting.renderer.ScmRenderer;
import org.bsc.maven.reporting.sink.ConfluenceSink;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="deploy", threadSafe=true)
public class ConfluenceDeployMojo
extends AbstractConfluenceSiteMojo {
    private static final String PROJECT_DEPENDENCIES_VAR = "project.dependencies";
    private static final String PROJECT_SCM_MANAGER_VAR = "project.scmManager";
    private static final String PROJECT_TEAM_VAR = "project.team";
    private static final String PROJECT_SUMMARY_VAR = "project.summary";
    private static final String GITLOG_JIRA_ISSUES_VAR = "gitlog.jiraIssues";
    private static final String GITLOG_SINCE_TAG_NAME = "gitlog.sinceTagName";
    public static final String PLUGIN_SUMMARY_VAR = "plugin.summary";
    public static final String PLUGIN_GOALS_VAR = "plugin.goals";
    @Parameter(defaultValue="false")
    protected boolean skip = false;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector collector;
    @Component(role=ArtifactFactory.class)
    protected ArtifactFactory factory;
    @Component
    private MavenProjectBuilder mavenProjectBuilder;
    @Component
    protected I18N i18n;
    @Parameter(property="project.build.directory/generated-site/confluence", required=true)
    protected File outputDirectory;
    @Component(role=ScmManager.class)
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project.artifactId}", required=true)
    private String checkoutDirectoryName;
    @Parameter(defaultValue="${project.scm.connection}")
    private String anonymousConnection;
    @Parameter(defaultValue="${project.scm.developerConnection}")
    private String developerConnection;
    @Parameter(defaultValue="${project.scm.url}")
    private String webAccessUrl;
    @Parameter(defaultValue="false")
    private Boolean gitLogJiraIssuesEnable;
    @Parameter(defaultValue="")
    private String gitLogSinceTagName;
    @Parameter(defaultValue="")
    private String gitLogUntilTagName;
    @Parameter(defaultValue="NO_RULE")
    private CalculateRuleForSinceTagName gitLogCalculateRuleForSinceTagName;
    @Parameter(defaultValue="")
    private List<String> gitLogJiraProjectKeyList;
    @Parameter(defaultValue="")
    private String gitLogTagNamesPattern;
    @Parameter(defaultValue="false")
    private Boolean gitLogGroupByVersions;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository local;
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", required=true, readonly=true)
    private List<ArtifactRepository> remoteRepos;
    @Component
    protected MojoScanner mojoScanner;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"plugin execution skipped");
            return;
        }
        if (Objects.nonNull(this.deployState)) {
            if (!this.deployState.getOutdir().isPresent()) {
                this.deployState.setOutdir(new File(this.getProject().getBuild().getDirectory()));
            }
            this.deployStateManager = DeployStateManager.load((String)this.getEndPoint(), (DeployStateManager.Parameters)this.deployState);
        }
        Locale locale = Locale.getDefault();
        this.getLog().info((CharSequence)String.format("executeReport isSnapshot = [%b] isRemoveSnapshots = [%b]", this.isSnapshot(), this.isRemoveSnapshots()));
        this.loadUserInfoFromSettings();
        Site site = super.createFromModel();
        if (site != null) {
            site.setBasedir(this.getSiteDescriptor().toPath());
            if (site.getHome().getName() != null) {
                this.setTitle(site.getHome().getName());
            } else {
                site.getHome().setName(this.getTitle());
            }
            List<String> _labels = this.getLabels();
            if (!_labels.isEmpty()) {
                site.getLabels().addAll(_labels);
            }
        } else {
            site = super.createFromFolder();
            try {
                Path p = this.templateWiki.toPath();
                site.setBasedir(p);
            }
            catch (Exception e) {
                site.setBasedir(this.getSiteDescriptor().toPath());
            }
        }
        SitePrinter.print((Site)site, (PrintStream)System.out);
        super.initTemplateProperties(site);
        try {
            if (this.project.getPackaging().equals("maven-plugin")) {
                this.generatePluginReport(site, locale);
            } else {
                this.generateProjectReport(site, locale);
            }
        }
        catch (MojoExecutionException e) {
            String msg = "error generating report";
            if (this.isFailOnError()) {
                throw e;
            }
            this.getLog().error((CharSequence)"error generating report", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "error generating report";
            Throwable cause = e.getCause();
            if (this.isFailOnError()) {
                throw new MojoExecutionException("error generating report", cause != null ? cause : e);
            }
            this.getLog().error((CharSequence)"error generating report", cause != null ? cause : e);
        }
    }

    protected void generateProjectHomeTemplate(MiniTemplator t, Site site, Locale locale) throws MojoExecutionException {
        if (t == null) {
            throw new IllegalArgumentException("templator is null!");
        }
        super.addStdProperties(t);
        StringWriter w = new StringWriter(10240);
        ConfluenceSink sink = new ConfluenceSink(w);
        ProjectSummaryRenderer summary = new ProjectSummaryRenderer((Sink)sink, this.project, this.i18n, locale);
        summary.render();
        try {
            String project_summary_var = w.toString();
            this.getProperties().put(PROJECT_SUMMARY_VAR, project_summary_var);
            t.setVariable(PROJECT_SUMMARY_VAR, project_summary_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_SUMMARY_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        ProjectTeamRenderer renderer = new ProjectTeamRenderer((Sink)sink, this.project.getModel(), this.i18n, locale, this.getLog(), false);
        renderer.render();
        try {
            String project_team_var = w.toString();
            this.getProperties().put(PROJECT_TEAM_VAR, project_team_var);
            t.setVariable(PROJECT_TEAM_VAR, project_team_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_TEAM_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        String scmTag = "";
        new ScmRenderer(this.getLog(), this.scmManager, (Sink)sink, this.project.getModel(), this.i18n, locale, this.checkoutDirectoryName, this.webAccessUrl, this.anonymousConnection, this.developerConnection, "").render();
        try {
            String project_scm_var = w.toString();
            this.getProperties().put(PROJECT_SCM_MANAGER_VAR, project_scm_var);
            t.setVariable(PROJECT_SCM_MANAGER_VAR, project_scm_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_SCM_MANAGER_VAR));
        }
        w = new StringWriter(10240);
        sink = new ConfluenceSink(w);
        new DependenciesRenderer((Sink)sink, this.project, this.mavenProjectBuilder, this.localRepository, this.factory, this.i18n, locale, this.resolveProject(), this.getLog()).render();
        try {
            String project_dependencies_var = w.toString();
            this.getProperties().put(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
            t.setVariable(PROJECT_DEPENDENCIES_VAR, project_dependencies_var);
        }
        catch (MiniTemplator.VariableNotDefinedException e) {
            this.getLog().debug((CharSequence)String.format("variable %s not defined in template", PROJECT_DEPENDENCIES_VAR));
        }
        if (this.gitLogJiraIssuesEnable.booleanValue()) {
            w = new StringWriter(10240);
            sink = new ConfluenceSink(w);
            String currentVersion = this.project.getVersion();
            GitLogJiraIssuesRenderer gitLogJiraIssuesRenderer = new GitLogJiraIssuesRenderer((Sink)sink, this.gitLogSinceTagName, this.gitLogUntilTagName, this.gitLogJiraProjectKeyList, currentVersion, this.gitLogCalculateRuleForSinceTagName, this.gitLogTagNamesPattern, this.gitLogGroupByVersions, this.getLog());
            gitLogJiraIssuesRenderer.render();
            this.gitLogSinceTagName = gitLogJiraIssuesRenderer.getGitLogSinceTagName();
            try {
                String gitlog_jiraissues_var = w.toString();
                this.getProperties().put(GITLOG_JIRA_ISSUES_VAR, gitlog_jiraissues_var);
                t.setVariable(GITLOG_JIRA_ISSUES_VAR, gitlog_jiraissues_var);
            }
            catch (MiniTemplator.VariableNotDefinedException e) {
                this.getLog().debug((CharSequence)String.format("variable %s not defined in template", GITLOG_JIRA_ISSUES_VAR));
            }
            try {
                if (this.gitLogSinceTagName == null) {
                    this.gitLogSinceTagName = "beginning of gitlog";
                }
                this.getProperties().put(GITLOG_SINCE_TAG_NAME, this.gitLogSinceTagName);
                t.setVariable(GITLOG_SINCE_TAG_NAME, this.gitLogSinceTagName);
            }
            catch (MiniTemplator.VariableNotDefinedException e) {
                this.getLog().debug((CharSequence)String.format("variable %s not defined in template", GITLOG_SINCE_TAG_NAME));
            }
        }
    }

    private CompletableFuture<Boolean> removeSnaphot(ConfluenceService confluence, ConfluenceService.Model.Page parentPage, String title) {
        if (!this.isSnapshot() && this.isRemoveSnapshots()) {
            String snapshot = title.concat("-SNAPSHOT");
            this.getLog().info((CharSequence)String.format("removing page [%s]!", snapshot));
            return ((CompletableFuture)confluence.removePage(parentPage, snapshot).thenApply(deleted -> {
                if (deleted.booleanValue()) {
                    this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot));
                }
                return deleted;
            })).exceptionally(ex -> (Boolean)this.throwRTE(String.format("Page [%s] cannot be removed!", snapshot), ex));
        }
        return CompletableFuture.completedFuture(false);
    }

    private CompletableFuture<ConfluenceService.Model.Page> updateHomeContent(ConfluenceService confluence, Site site, ConfluenceService.Model.Page homePage, Locale locale) {
        URI uri = site.getHome().getUri();
        return (CompletableFuture)SiteProcessor.processPageUri((URI)uri, (String)homePage.getTitle(), (err, tuple2) -> {
            CompletableFuture<ConfluenceService.Model.Page> result = new CompletableFuture<ConfluenceService.Model.Page>();
            try {
                if (err.isPresent()) {
                    result.completeExceptionally((Throwable)err.get());
                    return result;
                }
                if (!((Optional)tuple2.value1).isPresent()) {
                    result.complete(homePage);
                    return result;
                }
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build((InputStream)((Optional)tuple2.value1).get(), this.getCharset());
                this.generateProjectHomeTemplate(t, site, locale);
                return confluence.storePage(homePage, new ConfluenceService.Storage(t.generateOutput(), (ConfluenceService.Storage.Representation)tuple2.value2));
            }
            catch (Exception ex) {
                result.completeExceptionally(ex);
                return result;
            }
        });
    }

    private void generateProjectReport(ConfluenceService confluence, Site site, Locale locale) {
        ConfluenceService.Model.Page _parentPage = this.loadParentPage(confluence, Optional.of(site));
        String _homePageTitle = this.getTitle();
        ConfluenceService.Model.Page confluenceHomePage = (ConfluenceService.Model.Page)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.removeSnaphot(confluence, _parentPage, _homePageTitle).thenCompose(deleted -> confluence.getPage(_parentPage.getSpace(), _homePageTitle))).thenCompose(page2 -> page2.isPresent() ? CompletableFuture.completedFuture((ConfluenceService.Model.Page)page2.get()) : this.resetUpdateStatusForResource(site.getHome().getUri()).thenCompose(reset -> confluence.createPage(_parentPage, _homePageTitle)))).thenCompose(page -> this.canProceedToUpdateResource(site.getHome().getUri()).thenCompose(update -> {
            if (update.booleanValue()) {
                return this.updateHomeContent(confluence, site, (ConfluenceService.Model.Page)page, locale);
            }
            this.getLog().info((CharSequence)String.format("page [%s] has not been updated (deploy skipped)", this.getPrintableStringForResource(site.getHome().getUri())));
            return CompletableFuture.completedFuture(page);
        }))).join();
        for (String label : site.getHome().getComputedLabels()) {
            try {
                confluence.addLabelByName(label, Long.parseLong(confluenceHomePage.getId()));
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)String.format("Error adding label [%s] :\n%s", label, e.getMessage()));
            }
        }
        this.generateChildren(confluence, site, (Site.Page)site.getHome(), confluenceHomePage, new HashMap<String, ConfluenceService.Model.Page>());
    }

    private void generateProjectReport(Site site, Locale locale) {
        super.confluenceExecute(confluence -> this.generateProjectReport((ConfluenceService)confluence, site, locale));
    }

    private ReportingResolutionListener resolveProject() {
        Map<String, Artifact> managedVersions = null;
        try {
            managedVersions = this.createManagedVersionMap(this.project.getId(), this.project.getDependencyManagement());
        }
        catch (ProjectBuildingException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        ReportingResolutionListener listener = new ReportingResolutionListener();
        try {
            this.collector.collect(this.project.getDependencyArtifacts(), this.project.getArtifact(), managedVersions, this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (ArtifactResolutionException e) {
            this.getLog().error((CharSequence)"An error occurred while resolving project dependencies.", (Throwable)e);
        }
        return listener;
    }

    private Map<String, Artifact> createManagedVersionMap(String projectId, DependencyManagement dependencyManagement) throws ProjectBuildingException {
        Map<String, Artifact> map;
        if (dependencyManagement != null && dependencyManagement.getDependencies() != null) {
            map = new HashMap<String, Artifact>();
            for (Dependency d : dependencyManagement.getDependencies()) {
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
                    Artifact artifact = this.factory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope());
                    map.put(d.getManagementKey(), artifact);
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new ProjectBuildingException(projectId, "Unable to parse version '" + d.getVersion() + "' for dependency '" + d.getManagementKey() + "': " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            map = Collections.emptyMap();
        }
        return map;
    }

    public String getDescription(Locale locale) {
        return "confluence";
    }

    public String getOutputName() {
        return "confluence";
    }

    public String getName(Locale locale) {
        return "confluence";
    }

    private static List<ComponentDependency> toComponentDependencies(List<Dependency> dependencies) {
        return GeneratorUtils.toComponentDependencies(dependencies);
    }

    private void generatePluginReport(Site site, Locale locale) throws MojoExecutionException {
        String goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        PluginDescriptor pluginDescriptor = new PluginDescriptor();
        pluginDescriptor.setGroupId(this.project.getGroupId());
        pluginDescriptor.setArtifactId(this.project.getArtifactId());
        pluginDescriptor.setVersion(this.project.getVersion());
        pluginDescriptor.setGoalPrefix(goalPrefix);
        ArrayList<ComponentDependency> deps = new ArrayList<ComponentDependency>();
        deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getRuntimeDependencies()));
        deps.addAll(ConfluenceDeployMojo.toComponentDependencies(this.project.getCompileDependencies()));
        pluginDescriptor.setDependencies(deps);
        pluginDescriptor.setDescription(this.project.getDescription());
        DefaultPluginToolsRequest req = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
        req.setEncoding(this.getEncoding());
        req.setLocal(this.local);
        req.setRemoteRepos(this.remoteRepos);
        req.setSkipErrorNoDescriptorsFound(false);
        req.setDependencies(this.dependencies);
        try {
            this.mojoScanner.populatePluginDescriptor((PluginToolsRequest)req);
        }
        catch (InvalidPluginDescriptorException e) {
            this.getLog().warn((CharSequence)String.format("Plugin without mojos. %s\nMojoScanner:%s", e.getMessage(), this.mojoScanner.getClass()));
        }
        catch (ExtractionException e) {
            throw new MojoExecutionException(String.format("Error extracting plugin descriptor: %s", e.getLocalizedMessage()), (Exception)((Object)e));
        }
        super.confluenceExecute(confluence -> {
            ConfluenceService.Model.Page parentPage = this.loadParentPage((ConfluenceService)confluence, Optional.of(site));
            this.outputDirectory.mkdirs();
            this.getLog().info((CharSequence)String.format("speceKey=%s parentPageTitle=%s", parentPage.getSpace(), parentPage.getTitle()));
            PluginGenerator generator = new PluginGenerator();
            DefaultPluginToolsRequest request = new DefaultPluginToolsRequest(this.project, pluginDescriptor);
            try {
                ConfluenceService.Model.Page confluenceHomePage = generator.processMojoDescriptors(request.getPluginDescriptor(), (ConfluenceService)confluence, parentPage, site, locale);
                for (String label : site.getHome().getComputedLabels()) {
                    confluence.addLabelByName(label, Long.parseLong(confluenceHomePage.getId()));
                }
                HashMap<String, ConfluenceService.Model.Page> varsToParentPageMap = new HashMap<String, ConfluenceService.Model.Page>();
                this.generateChildren((ConfluenceService)confluence, site, (Site.Page)site.getHome(), confluenceHomePage, (Map<String, ConfluenceService.Model.Page>)varsToParentPageMap);
                generator.generateGoalsPages((ConfluenceService)confluence, confluenceHomePage, (Map<String, ConfluenceService.Model.Page>)varsToParentPageMap);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    class PluginGenerator
    extends PluginConfluenceDocGenerator {
        final List<PluginConfluenceDocGenerator.Goal> goals = new ArrayList<PluginConfluenceDocGenerator.Goal>();

        PluginGenerator() {
        }

        void generateGoalsPages(ConfluenceService confluence, ConfluenceService.Model.Page confluenceHome, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
            ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Get the right page to generate the %s pages under", ConfluenceDeployMojo.PLUGIN_GOALS_VAR));
            ConfluenceService.Model.Page goalsParentPage = confluenceHome;
            if (varsToParentPageMap.containsKey(ConfluenceDeployMojo.PLUGIN_GOALS_VAR)) {
                goalsParentPage = varsToParentPageMap.get(ConfluenceDeployMojo.PLUGIN_GOALS_VAR);
            }
            ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("Plugin Goals parentPage is: %s", goalsParentPage.getTitle()));
            for (PluginConfluenceDocGenerator.Goal goal : this.goals) {
                try {
                    ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("- generating: %s", goal.getPageName(confluenceHome.getTitle())));
                    goal.generatePage(confluence, goalsParentPage, confluenceHome.getTitle());
                }
                catch (Exception ex) {
                    ConfluenceDeployMojo.this.getLog().warn((CharSequence)String.format("error generatig page for goal [%s]", goal.descriptor.getGoal()), (Throwable)ex);
                }
            }
        }

        private CompletableFuture<ConfluenceService.Model.Page> updateHomeContent(ConfluenceService confluence, Site site, ConfluenceService.Model.Page homePage, PluginDescriptor pluginDescriptor, Locale locale) {
            List mojos = pluginDescriptor.getMojos();
            if (mojos == null) {
                ConfluenceDeployMojo.this.getLog().warn((CharSequence)"no mojos found [pluginDescriptor.getMojos()]");
            } else if (ConfluenceDeployMojo.this.getLog().isDebugEnabled()) {
                ConfluenceDeployMojo.this.getLog().debug((CharSequence)"Found the following Mojos:");
                for (MojoDescriptor mojo : mojos) {
                    ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("  - %s : %s", mojo.getFullGoalName(), mojo.getDescription()));
                }
            }
            String title = ConfluenceDeployMojo.this.getTitle();
            return (CompletableFuture)SiteProcessor.processPageUri((URI)site.getHome().getUri(), (String)ConfluenceDeployMojo.this.getTitle(), (err, tuple2) -> {
                CompletableFuture<ConfluenceService.Model.Page> result = new CompletableFuture<ConfluenceService.Model.Page>();
                try {
                    if (err.isPresent()) {
                        result.completeExceptionally((Throwable)err.get());
                        return result;
                    }
                    if (!((Optional)tuple2.value1).isPresent()) {
                        result.complete(homePage);
                        return result;
                    }
                    MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build((InputStream)((Optional)tuple2.value1).get(), ConfluenceDeployMojo.this.getCharset());
                    StringWriter writer = new StringWriter(102400);
                    this.writeSummary(writer, pluginDescriptor);
                    writer.flush();
                    try {
                        String summary = writer.toString();
                        ConfluenceDeployMojo.this.getProperties().put(ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, summary);
                        t.setVariable(ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, summary);
                    }
                    catch (MiniTemplator.VariableNotDefinedException e) {
                        ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("variable %s or %s not defined in template", ConfluenceDeployMojo.PLUGIN_SUMMARY_VAR, ConfluenceDeployMojo.PROJECT_SUMMARY_VAR));
                    }
                    ConfluenceDeployMojo.this.generateProjectHomeTemplate(t, site, locale);
                    writer = new StringWriter(102400);
                    this.goals.addAll(this.writeGoalsAsChildren(writer, title, mojos));
                    writer.flush();
                    try {
                        String plugin_goals = writer.toString();
                        ConfluenceDeployMojo.this.getProperties().put(ConfluenceDeployMojo.PLUGIN_GOALS_VAR, plugin_goals);
                        t.setVariable(ConfluenceDeployMojo.PLUGIN_GOALS_VAR, plugin_goals);
                    }
                    catch (MiniTemplator.VariableNotDefinedException e) {
                        ConfluenceDeployMojo.this.getLog().debug((CharSequence)String.format("variable %s not defined in template", ConfluenceDeployMojo.PLUGIN_GOALS_VAR));
                    }
                    return confluence.storePage(homePage, new ConfluenceService.Storage(t.generateOutput(), ConfluenceService.Storage.Representation.WIKI));
                }
                catch (Exception ex) {
                    result.completeExceptionally(ex);
                    return result;
                }
            });
        }

        public ConfluenceService.Model.Page processMojoDescriptors(PluginDescriptor pluginDescriptor, ConfluenceService confluence, ConfluenceService.Model.Page parentPage, Site site, Locale locale) throws Exception {
            String title = ConfluenceDeployMojo.this.getTitle();
            ConfluenceDeployMojo.this.getProperties().put("pageTitle", title);
            ConfluenceDeployMojo.this.getProperties().put("artifactId", ConfluenceDeployMojo.this.getProject().getArtifactId());
            ConfluenceDeployMojo.this.getProperties().put("version", ConfluenceDeployMojo.this.getProject().getVersion());
            return (ConfluenceService.Model.Page)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)ConfluenceDeployMojo.this.removeSnaphot(confluence, parentPage, title).thenCompose(deleted -> confluence.getPage(parentPage.getSpace(), parentPage.getTitle()))).exceptionally(ex -> (Optional)ConfluenceDeployMojo.this.throwRTE("cannot find parent page [%s] in space [%s]", parentPage.getTitle(), ex))).thenApply(parent -> (ConfluenceService.Model.Page)parent.orElseThrow(() -> ConfluenceDeployMojo.this.RTE("cannot find parent page [%s] in space [%s]", parentPage.getTitle())))).thenCombine((CompletionStage)confluence.getPage(parentPage.getSpace(), title), Tuple2::of)).thenCompose(tuple -> ((Optional)tuple.value2).isPresent() ? CompletableFuture.completedFuture((ConfluenceService.Model.Page)((Optional)tuple.value2).get()) : ConfluenceDeployMojo.this.resetUpdateStatusForResource(site.getHome().getUri()).thenCompose(reset -> confluence.createPage((ConfluenceService.Model.Page)tuple2.value1, title)))).thenCompose(p -> ConfluenceDeployMojo.this.canProceedToUpdateResource(site.getHome().getUri()).thenCompose(update -> {
                if (update.booleanValue()) {
                    return this.updateHomeContent(confluence, site, (ConfluenceService.Model.Page)p, pluginDescriptor, locale);
                }
                ConfluenceDeployMojo.this.getLog().info((CharSequence)String.format("page [%s] has not been updated (deploy skipped)", ConfluenceDeployMojo.this.getPrintableStringForResource(site.getHome().getUri())));
                return confluence.storePage(p);
            }))).join();
        }
    }
}

