/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;

public class ReportingResolutionListener
implements ResolutionListener {
    private Stack<Node> parents = new Stack();
    private Map<String, Object> artifacts = new HashMap<String, Object>();
    private Node rootNode;

    public void testArtifact(Artifact artifact) {
    }

    public void startProcessChildren(Artifact artifact) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (this.parents.isEmpty()) {
            this.rootNode = node;
        }
        this.parents.push(node);
    }

    public void endProcessChildren(Artifact artifact) {
        Node check = this.parents.pop();
        assert (artifact.equals(check.artifact));
    }

    public void omitForNearer(Artifact omitted, Artifact kept) {
        assert (omitted.getDependencyConflictId().equals(kept.getDependencyConflictId()));
        Node prev = (Node)this.artifacts.get(omitted.getDependencyConflictId());
        if (prev != null) {
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(omitted.getDependencyConflictId());
        }
        this.includeArtifact(kept);
    }

    public void omitForCycle(Artifact artifact) {
    }

    public void includeArtifact(Artifact artifact) {
        if (this.artifacts.containsKey(artifact.getDependencyConflictId())) {
            Node prev = (Node)this.artifacts.get(artifact.getDependencyConflictId());
            if (prev.parent != null) {
                prev.parent.children.remove(prev);
            }
            this.artifacts.remove(artifact.getDependencyConflictId());
        }
        Node node = new Node();
        node.artifact = artifact;
        if (!this.parents.isEmpty()) {
            node.parent = this.parents.peek();
            node.parent.children.add(node);
        }
        this.artifacts.put(artifact.getDependencyConflictId(), node);
    }

    public void updateScope(Artifact artifact, String scope) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        node.artifact.setScope(scope);
    }

    public void manageArtifact(Artifact artifact, Artifact replacement) {
        Node node = (Node)this.artifacts.get(artifact.getDependencyConflictId());
        if (node != null) {
            if (replacement.getVersion() != null) {
                node.artifact.setVersion(replacement.getVersion());
            }
            if (replacement.getScope() != null) {
                node.artifact.setScope(replacement.getScope());
            }
        }
    }

    public void updateScopeCurrentPom(Artifact artifact, String key) {
    }

    public void selectVersionFromRange(Artifact artifact) {
    }

    public void restrictRange(Artifact artifact, Artifact artifact1, VersionRange versionRange) {
    }

    public Collection<Object> getArtifacts() {
        return this.artifacts.values();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public static class Node {
        private Node parent;
        private List<Object> children = new ArrayList<Object>();
        private Artifact artifact;

        public List<Object> getChildren() {
            return this.children;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }
    }
}

