/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import java.io.File;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ExportFormat;
import org.bsc.mojo.AbstractBaseConfluenceMojo;

@Mojo(name="export", threadSafe=true, requiresProject=false)
public class ConfluenceExportMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(alias="outputType", property="outputType", defaultValue="pdf")
    private String outputType;
    @Parameter(alias="outputFile")
    private File outputFile;
    @Parameter(property="project.build.directory", readonly=true)
    private File outputDirectory;

    private void exportPage(ConfluenceService confluence) throws Exception {
        ExportFormat exfmt = ExportFormat.valueOf((String)this.outputType.toUpperCase());
        ConfluenceService.Model.Page parentPage = this.loadParentPage(confluence, Optional.empty()).join();
        if (this.outputFile == null) {
            this.outputFile = this.outputDirectory == null ? new File(String.format("%s.%s", this.pageTitle, exfmt.name().toLowerCase())) : new File(this.outputDirectory, String.format("%s.%s", this.pageTitle, exfmt.name().toLowerCase()));
        }
        FileUtils.forceMkdir((File)new File(this.outputFile.getParent()));
        String url = ConfluenceService.Protocol.XMLRPC.removeFrom(ConfluenceExportMojo.super.getEndPoint());
        confluence.exportPage(url, parentPage.getSpace(), this.pageTitle, exfmt, this.outputFile);
    }

    @Override
    public void execute(ConfluenceService confluence) throws Exception {
        this.exportPage(confluence);
    }
}

