/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.DeployStateManager;
import org.bsc.confluence.model.ProcessUriException;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteProcessor;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceMojo;

public abstract class AbstractConfluenceMojo
extends AbstractBaseConfluenceMojo {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/site/confluence/template.wiki")
    protected File templateWiki;
    @Parameter(defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;
    @Parameter(defaultValue="${basedir}/src/site/confluence/children")
    private File childrenFolder;
    @Parameter(property="confluence.removeSnapshots", required=false, defaultValue="false")
    protected boolean removeSnapshots = false;
    @Parameter(property="confluence.childrenTitlesPrefixed", required=false, defaultValue="true")
    protected boolean childrenTitlesPrefixed = true;
    @Parameter
    List<String> labels;
    @Parameter(alias="title", property="project.build.finalName", required=false)
    private String title;
    @Parameter(property="wikiFilesExt", required=false, defaultValue=".wiki")
    private String wikiFilesExt;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter
    protected DeployStateManager.Parameters deployState;
    protected DeployStateManager deployStateManager;

    protected File getChildrenFolder() {
        return this.childrenFolder;
    }

    protected File getAttachmentFolder() {
        return this.attachmentFolder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final Charset getCharset() {
        if (this.encoding == null) {
            this.getLog().debug((CharSequence)"encoding is null! default charset will be used");
            return Charset.defaultCharset();
        }
        try {
            Charset result = Charset.forName(this.encoding);
            return result;
        }
        catch (UnsupportedCharsetException e) {
            this.getLog().warn((CharSequence)String.format("encoding [%s] is not valid! default charset will be used", this.encoding));
            return Charset.defaultCharset();
        }
    }

    protected final String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public boolean isChildrenTitlesPrefixed() {
        return this.childrenTitlesPrefixed;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return this.labels;
    }

    protected String getPrintableStringForResource(URI uri) {
        try {
            Path p = Paths.get(uri);
            return this.getProject().getBasedir().toPath().relativize(p).toString();
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    protected void initTemplateProperties(Site site) {
        this.processProperties(site);
        this.getProperties().put("pageTitle", this.getTitle());
        this.getProperties().put("home.title", this.getTitle());
        this.getProperties().put("page.title", this.getTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    public void addStdProperties(MiniTemplator t) {
        Map<String, String> props = this.getProperties();
        if (props == null || props.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                try {
                    t.setVariable(e.getKey(), e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().debug((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    private <T extends Site.Page> CompletableFuture<ConfluenceService.Model.Page> updatePageContent(ConfluenceService confluence, ConfluenceService.Model.Page pageToUpdate, Site site, URI source, T child, String pageName) {
        return (CompletableFuture)SiteProcessor.processPageUri((URI)source, (String)this.getTitle(), (err, tuple2) -> {
            CompletableFuture result = new CompletableFuture();
            if (err.isPresent()) {
                result.completeExceptionally(this.RTE("error processing uri [%s]", source, err.get()));
                return result;
            }
            try {
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build((InputStream)((Optional)tuple2.value1).get(), this.getCharset());
                if (!child.isIgnoreVariables().booleanValue()) {
                    this.addStdProperties(t);
                    t.setVariableOpt("childTitle", pageName);
                    t.setVariableOpt("page.title", pageName);
                }
                return confluence.storePage(pageToUpdate, new ConfluenceService.Storage(t.generateOutput(), (ConfluenceService.Storage.Representation)tuple2.value2));
            }
            catch (Exception ex) {
                result.completeExceptionally(this.RTE("error storing page [%s]", pageToUpdate.getTitle(), ex));
                return result;
            }
        });
    }

    protected <T extends Site.Page> ConfluenceService.Model.Page generateChild(ConfluenceService confluence, Site site, T child, ConfluenceService.Model.Page parentPage) {
        String pageTitle;
        String homeTitle = site.getHome().getName();
        URI source = child.getUri(this.getFileExt());
        this.getLog().debug((CharSequence)String.format("generateChild\n\tspacekey=[%s]\n\thome=[%s]\n\tparent=[%s]\n\tpage=[%s]\n\t%s", parentPage.getSpace(), homeTitle, parentPage.getTitle(), child.getName(), this.getPrintableStringForResource(source)));
        String string = pageTitle = !this.isChildrenTitlesPrefixed() ? child.getName() : String.format("%s - %s", homeTitle, child.getName());
        if (!this.isSnapshot() && this.isRemoveSnapshots()) {
            String snapshot = pageTitle.concat("-SNAPSHOT");
            ((CompletableFuture)confluence.removePage(parentPage, snapshot).thenAccept(deleted -> this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot)))).exceptionally(ex -> (Void)this.throwRTE("page [%s] not found!", snapshot, ex));
        }
        ConfluenceService.Model.Page result = (ConfluenceService.Model.Page)((CompletableFuture)((CompletableFuture)confluence.getPage(parentPage.getSpace(), pageTitle).thenCompose(page -> page.isPresent() ? CompletableFuture.completedFuture((ConfluenceService.Model.Page)page.get()) : this.resetUpdateStatusForResource(source).thenCompose(reset -> confluence.createPage(parentPage, pageTitle)))).thenCompose(p -> this.canProceedToUpdateResource(source).thenCompose(update -> {
            if (update.booleanValue()) {
                return this.updatePageContent(confluence, (ConfluenceService.Model.Page)p, site, source, child, pageTitle);
            }
            this.getLog().info((CharSequence)String.format("page [%s] has not been updated (deploy skipped)", this.getPrintableStringForResource(source)));
            return CompletableFuture.completedFuture(p);
        }))).join();
        try {
            for (String label : child.getComputedLabels()) {
                confluence.addLabelByName(label, Long.parseLong(result.getId()));
            }
            child.setName(pageTitle);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processProperties(Site site) {
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            try {
                String v = e.getValue();
                if (v == null) {
                    this.getLog().warn((CharSequence)String.format("property [%s] has null value!", e.getKey()));
                    continue;
                }
                URI uri = new URI(v);
                if (uri.getScheme() == null) continue;
                this.getProperties().put(e.getKey(), this.processUriContent(site, uri, this.getCharset()));
            }
            catch (ProcessUriException ex) {
                this.getLog().warn((CharSequence)String.format("error processing value of property [%s]\n%s", e.getKey(), ex.getMessage()));
                if (ex.getCause() == null) continue;
                this.getLog().debug(ex.getCause());
            }
            catch (URISyntaxException ex) {
                this.getLog().debug((CharSequence)String.format("property [%s] is not a valid uri", e.getKey()));
            }
        }
    }

    private String processUriContent(Site site, URI uri, Charset charset) throws ProcessUriException {
        try {
            return (String)SiteProcessor.processUriContent((URI)uri, (String)this.getTitle(), (is, r) -> {
                try {
                    return this.toString((InputStream)is, charset);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception ex) {
            throw new ProcessUriException("error reading content!", (Throwable)ex);
        }
    }

    private String toString(InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream");
        }
        try (InputStreamReader r = new InputStreamReader(stream, charset);){
            int c;
            StringBuilder contents = new StringBuilder(4096);
            while ((c = ((Reader)r).read()) != -1) {
                contents.append((char)c);
            }
            String string = contents.toString();
            return string;
        }
    }

    protected CompletableFuture<Void> resetUpdateStatusForResource(URI uri) {
        if (uri != null && this.deployStateManager != null) {
            this.deployStateManager.resetState(uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Boolean> canProceedToUpdateResource(URI uri) {
        if (uri == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.deployStateManager == null) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(this.deployStateManager.isUpdated(uri));
    }
}

