/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.mavenplugins.gitlog;

import com.github.qwazer.mavenplugins.gitlog.NoGitRepositoryException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public class GitLogUtil {
    public static Repository openRepository() throws NoGitRepositoryException, IOException {
        Repository repository = null;
        try {
            repository = ((RepositoryBuilder)new RepositoryBuilder().findGitDir()).build();
        }
        catch (IllegalArgumentException iae) {
            throw new NoGitRepositoryException();
        }
        return repository;
    }

    public static Set<String> loadVersionTagList(Repository repository, String versionTagNamePattern) {
        HashSet<String> versionTagList = new HashSet();
        if (versionTagNamePattern != null) {
            versionTagList = new HashSet();
            for (String tagName : repository.getTags().keySet()) {
                if (!tagName.matches(versionTagNamePattern)) continue;
                versionTagList.add(tagName);
            }
        } else {
            versionTagList = repository.getTags().keySet();
        }
        return versionTagList;
    }

    protected static RevCommit resolveCommitIdByTagName(Repository repository, String tagName) throws IOException, GitAPIException {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        RevCommit revCommit = null;
        Map tagMap = repository.getTags();
        Ref ref = (Ref)tagMap.get(tagName);
        if (ref != null) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (RevWalk walk = new RevWalk(repository);){
                walk.setRetainBody(false);
                ObjectId from = repository.resolve("refs/heads/master");
                if (from == null) {
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (Git git = new Git(repository);){
                        String lastTagName = git.describe().call();
                        from = repository.resolve("refs/tags/" + lastTagName);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                if (from == null) {
                    throw new IllegalStateException("cannot determinate start commit");
                }
                ObjectId to = repository.resolve("refs/remotes/origin/master");
                walk.markStart(walk.parseCommit((AnyObjectId)from));
                walk.markUninteresting(walk.parseCommit((AnyObjectId)to));
                RevObject revObject = walk.parseAny((AnyObjectId)ref.getObjectId());
                if (revObject != null) {
                    revCommit = walk.parseCommit((AnyObjectId)revObject.getId());
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        return revCommit;
    }

    public static Set<String> extractJiraIssues(Repository repository, String sinceTagName, String untilTagName, String pattern) throws IOException, GitAPIException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = new Git(repository);){
            RevCommit startCommitId = GitLogUtil.resolveCommitIdByTagName(repository, sinceTagName);
            if (startCommitId == null) {
                throw new IOException("cannot resolveCommitIdByTagName by  " + sinceTagName);
            }
            RevCommit endCommitId = GitLogUtil.resolveCommitIdByTagName(repository, untilTagName);
            if (endCommitId == null) {
                endCommitId = repository.resolve("HEAD");
            }
            Iterable commits = git.log().addRange((AnyObjectId)startCommitId, (AnyObjectId)endCommitId).call();
            return GitLogUtil.extractJiraIssues(pattern, commits);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static LinkedHashMap<String, Set<String>> extractJiraIssuesByVersion(Repository repository, List<String> versionTagList, String pattern) throws IOException, GitAPIException {
        LinkedHashMap<String, Set<String>> linkedHashMap = new LinkedHashMap<String, Set<String>>();
        int lenght = versionTagList.size();
        int i = 0;
        while (i < lenght) {
            String sinceTagName = versionTagList.get(i);
            String untilTagName = i + 1 > lenght - 1 ? null : versionTagList.get(i + 1);
            linkedHashMap.put(versionTagList.get(i), GitLogUtil.extractJiraIssues(repository, sinceTagName, untilTagName, pattern));
            ++i;
        }
        return linkedHashMap;
    }

    private static Set<String> extractJiraIssues(String pattern, Iterable<RevCommit> commits) {
        LinkedHashSet<String> jiraIssues = new LinkedHashSet<String>();
        for (RevCommit commit : commits) {
            jiraIssues.addAll(GitLogUtil.extractJiraIssuesFromString(commit.getFullMessage(), pattern));
        }
        return jiraIssues;
    }

    protected static List<String> extractJiraIssuesFromString(String s, String jiraIssuePattern) {
        Pattern p = Pattern.compile(jiraIssuePattern);
        Matcher m = p.matcher(s);
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            list.add(m.group(0));
        }
        return list;
    }
}

