/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.DeployStateManager;
import org.bsc.confluence.model.ProcessUriException;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteFactory;
import org.bsc.confluence.model.SiteProcessor;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceSiteMojo;

public abstract class AbstractConfluenceDeployMojo
extends AbstractBaseConfluenceSiteMojo
implements SiteFactory.Folder {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/site/confluence/template.wiki")
    protected File templateWiki;
    @Parameter(property="confluence.removeSnapshots", required=false, defaultValue="false")
    protected boolean removeSnapshots = false;
    @Parameter(property="confluence.childrenTitlesPrefixed", required=false, defaultValue="true")
    protected boolean childrenTitlesPrefixed = true;
    @Parameter
    List<String> labels;
    @Parameter(property="wikiFilesExt", required=false, defaultValue=".wiki")
    private String wikiFilesExt;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter
    protected DeployStateManager.Parameters deployState;
    protected DeployStateManager deployStateManager;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final Charset getCharset() {
        if (this.encoding == null) {
            this.getLog().debug((CharSequence)"encoding is null! default charset will be used");
            return Charset.defaultCharset();
        }
        try {
            Charset result = Charset.forName(this.encoding);
            return result;
        }
        catch (UnsupportedCharsetException e) {
            this.getLog().warn((CharSequence)String.format("encoding [%s] is not valid! default charset will be used", this.encoding));
            return Charset.defaultCharset();
        }
    }

    public String getFileExt() {
        return this.wikiFilesExt.charAt(0) == '.' ? this.wikiFilesExt : ".".concat(this.wikiFilesExt);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isRemoveSnapshots() {
        return this.removeSnapshots;
    }

    public boolean isSnapshot() {
        String version = this.project.getVersion();
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public boolean isChildrenTitlesPrefixed() {
        return this.childrenTitlesPrefixed;
    }

    public List<String> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return this.labels;
    }

    protected void initTemplateProperties(Site site) {
        this.processProperties(site);
        this.getProperties().put("pageTitle", this.getPageTitle());
        this.getProperties().put("home.title", this.getPageTitle());
        this.getProperties().put("page.title", this.getPageTitle());
        this.getProperties().put("artifactId", this.project.getArtifactId());
        this.getProperties().put("version", this.project.getVersion());
        this.getProperties().put("groupId", this.project.getGroupId());
        this.getProperties().put("name", this.project.getName());
        this.getProperties().put("description", this.project.getDescription());
        Properties projectProps = this.project.getProperties();
        if (projectProps != null) {
            for (Map.Entry<Object, Object> e : projectProps.entrySet()) {
                this.getProperties().put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
            }
        }
    }

    protected String getPrintableStringForResource(URI uri) {
        try {
            Path p = Paths.get(uri);
            return this.getProject().getBasedir().toPath().relativize(p).toString();
        }
        catch (Exception e) {
            return uri.toString();
        }
    }

    private <T extends Site.Page> CompletableFuture<ConfluenceService.Model.Page> updatePageContent(ConfluenceService confluence, ConfluenceService.Model.Page pageToUpdate, Site site, URI source, T child, String pageName) {
        return (CompletableFuture)SiteProcessor.processPageUri((Site)site, (ConfluenceService.Model.Page)pageToUpdate, (URI)source, (String)this.getPageTitle(), (err, content) -> {
            CompletableFuture result = new CompletableFuture();
            if (err.isPresent()) {
                result.completeExceptionally(this.RTE("error processing uri [%s]", source, err.get()));
                return result;
            }
            if (!content.isPresent()) {
                result.completeExceptionally(this.RTE("error content not present processing uri [%s]", source));
                return result;
            }
            try {
                MiniTemplator t = new MiniTemplator.Builder().setSkipUndefinedVars(true).build(((SiteProcessor.PageContent)content.get()).getInputStream(), this.getCharset());
                if (!child.isIgnoreVariables().booleanValue()) {
                    this.addStdProperties(t);
                    t.setVariableOpt("childTitle", pageName);
                    t.setVariableOpt("page.title", pageName);
                }
                return confluence.storePage(pageToUpdate, new ConfluenceService.Storage(t.generateOutput(), ((SiteProcessor.PageContent)content.get()).getType()));
            }
            catch (Exception ex) {
                result.completeExceptionally(this.RTE("error storing page [%s]", pageToUpdate.getTitle(), ex));
                return result;
            }
        });
    }

    protected <T extends Site.Page> ConfluenceService.Model.Page generateChild(ConfluenceService confluence, Site site, T child, ConfluenceService.Model.Page parentPage) {
        String pageTitle;
        String homeTitle = site.getHome().getName();
        URI source = child.getUri(this.getFileExt());
        this.getLog().debug((CharSequence)String.format("generateChild\n\tspacekey=[%s]\n\thome=[%s]\n\tparent=[%s]\n\tpage=[%s]\n\t%s", parentPage.getSpace(), homeTitle, parentPage.getTitle(), child.getName(), this.getPrintableStringForResource(source)));
        String string = pageTitle = !this.isChildrenTitlesPrefixed() ? child.getName() : String.format("%s - %s", homeTitle, child.getName());
        if (!this.isSnapshot() && this.isRemoveSnapshots()) {
            String snapshot = pageTitle.concat("-SNAPSHOT");
            ((CompletableFuture)confluence.removePage(parentPage, snapshot).thenAccept(deleted -> this.getLog().info((CharSequence)String.format("Page [%s] has been removed!", snapshot)))).exceptionally(ex -> (Void)this.throwRTE("page [%s] not found!", snapshot, ex));
        }
        ConfluenceService.Model.Page result = (ConfluenceService.Model.Page)((CompletableFuture)((CompletableFuture)confluence.getPage(parentPage.getSpace(), pageTitle).thenCompose(page -> page.isPresent() ? CompletableFuture.completedFuture(page.get()) : this.resetUpdateStatusForResource(source).thenCompose(reset -> confluence.createPage(parentPage, pageTitle)))).thenCompose(p -> this.canProceedToUpdateResource(source).thenCompose(update -> {
            if (update.booleanValue()) {
                return this.updatePageContent(confluence, (ConfluenceService.Model.Page)p, site, source, child, pageTitle);
            }
            this.getLog().info((CharSequence)String.format("page [%s] has not been updated (deploy skipped)", this.getPrintableStringForResource(source)));
            return CompletableFuture.completedFuture(p);
        }))).join();
        try {
            for (String label : child.getComputedLabels()) {
                confluence.addLabelByName(label, Long.parseLong(result.getId()));
            }
            child.setName(pageTitle);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processProperties(Site site) {
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            try {
                String v = e.getValue();
                if (v == null) {
                    this.getLog().warn((CharSequence)String.format("property [%s] has null value!", e.getKey()));
                    continue;
                }
                URI uri = new URI(v);
                if (uri.getScheme() == null) continue;
                this.getProperties().put(e.getKey(), this.processUriContent(site, uri, this.getCharset()));
            }
            catch (ProcessUriException ex) {
                this.getLog().warn((CharSequence)String.format("error processing value of property [%s]\n%s", e.getKey(), ex.getMessage()));
                if (ex.getCause() == null) continue;
                this.getLog().debug(ex.getCause());
            }
            catch (URISyntaxException ex) {
                this.getLog().debug((CharSequence)String.format("property [%s] is not a valid uri", e.getKey()));
            }
        }
    }

    protected CompletableFuture<Void> resetUpdateStatusForResource(URI uri) {
        if (uri != null && this.deployStateManager != null) {
            this.deployStateManager.resetState(uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Boolean> canProceedToUpdateResource(URI uri) {
        if (uri == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.deployStateManager == null) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.completedFuture(this.deployStateManager.isUpdated(uri));
    }

    private String processUriContent(Site site, URI uri, Charset charset) throws ProcessUriException {
        try {
            return (String)SiteProcessor.processUriContent((Site)site, (URI)uri, (String)this.getPageTitle(), content -> {
                try {
                    return this.toString(content.getInputStream(), charset);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
        }
        catch (Exception ex) {
            throw new ProcessUriException("error reading content!", (Throwable)ex);
        }
    }

    private String toString(InputStream stream, Charset charset) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream");
        }
        try (InputStreamReader r = new InputStreamReader(stream, charset);){
            int c;
            StringBuilder contents = new StringBuilder(4096);
            while ((c = ((Reader)r).read()) != -1) {
                contents.append((char)c);
            }
            String string = contents.toString();
            return string;
        }
    }

    private void setPageUriFormFile(Site.Page page, File source) {
        if (page == null) {
            throw new IllegalArgumentException("page is null!");
        }
        if (source != null && source.exists() && source.isFile() && source.canRead()) {
            page.setUri(source.toURI());
        } else {
            try {
                URL sourceUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("defaultTemplate.confluence");
                page.setUri(sourceUrl.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private DirectoryStream<Path> newDirectoryStream(Path attachmentPath, Site.Attachment attachment) throws IOException {
        if (StringUtils.isNotBlank((String)attachment.getName())) {
            return Files.newDirectoryStream(attachmentPath, attachment.getName());
        }
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory(entry, new LinkOption[0]) && !Files.isHidden(entry) && !Files.isSymbolicLink(entry) && Files.isReadable(entry);
            }
        };
        return Files.newDirectoryStream(attachmentPath, (DirectoryStream.Filter<? super Path>)filter);
    }

    private void generateAttachments(ConfluenceService confluence, Site site, Site.Page page, ConfluenceService.Model.Page confluencePage) {
        this.getLog().debug((CharSequence)String.format("generateAttachments pageId [%s] title [%s]", confluencePage.getId(), confluencePage.getTitle()));
        for (Site.Attachment attachment : page.getAttachments()) {
            Path attachmentPath = Paths.get(attachment.getUri());
            try {
                if (!Files.isDirectory(attachmentPath, new LinkOption[0])) {
                    ConfluenceService.Model.Attachment result = this.generateAttachment(confluence, site, confluencePage, attachment).get();
                    this.getLog().debug((CharSequence)String.format("generated attachment: %s", result.toString()));
                    continue;
                }
                try {
                    DirectoryStream<Path> dirStream = this.newDirectoryStream(attachmentPath, attachment);
                    Throwable throwable = null;
                    try {
                        for (Path p : dirStream) {
                            Site.Attachment fileAttachment = new Site.Attachment();
                            fileAttachment.setName(p.getFileName().toString());
                            fileAttachment.setUri(p.toUri());
                            fileAttachment.setComment(attachment.getComment());
                            fileAttachment.setVersion(attachment.getVersion());
                            if (StringUtils.isNotEmpty((String)attachment.getContentType())) {
                                fileAttachment.setContentType(attachment.getContentType());
                            }
                            ConfluenceService.Model.Attachment result = this.generateAttachment(confluence, site, confluencePage, fileAttachment).get();
                            this.getLog().debug((CharSequence)String.format("generated attachment: %s", result.toString()));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dirStream == null) continue;
                        if (throwable != null) {
                            try {
                                dirStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dirStream.close();
                    }
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)String.format("error reading directory [%s]", attachmentPath), (Throwable)ex);
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                this.getLog().warn((CharSequence)String.format("error generating remote attachment from [%s]", attachment.getName()), (Throwable)ex);
            }
        }
    }

    private CompletableFuture<ConfluenceService.Model.Attachment> updateAttachmentData(ConfluenceService confluence, Site site, URI uri, ConfluenceService.Model.Page confluencePage, ConfluenceService.Model.Attachment attachment) {
        return (CompletableFuture)SiteProcessor.processUri((URI)uri, (err, is) -> {
            if (err.isPresent()) {
                CompletableFuture result = new CompletableFuture();
                result.completeExceptionally((Throwable)err.get());
                return result;
            }
            if (!is.isPresent()) {
                this.getLog().warn((CharSequence)String.format("getting problem to read local attacchment file at [%s]", uri));
                return CompletableFuture.completedFuture(attachment);
            }
            return confluence.addAttachment(confluencePage, attachment, (InputStream)is.get());
        });
    }

    private CompletableFuture<ConfluenceService.Model.Attachment> generateAttachment(ConfluenceService confluence, Site site, ConfluenceService.Model.Page confluencePage, Site.Attachment attachment) {
        this.getLog().debug((CharSequence)String.format("generateAttachment\n\tpageId:[%s]\n\ttitle:[%s]\n\tfile:[%s]", confluencePage.getId(), confluencePage.getTitle(), this.getPrintableStringForResource(attachment.getUri())));
        URI uri = attachment.getUri();
        return ((CompletableFuture)((CompletableFuture)confluence.getAttachment(confluencePage.getId(), attachment.getName(), attachment.getVersion()).exceptionally(e -> {
            this.getLog().debug((CharSequence)String.format("Error getting attachment [%s] from confluence: [%s]", attachment.getName(), e.getMessage()));
            return Optional.empty();
        })).thenCompose(att -> {
            if (!att.isPresent()) {
                this.getLog().debug((CharSequence)String.format("Creating new attachment for [%s]", attachment.getName()));
                ConfluenceService.Model.Attachment result = confluence.createAttachment();
                result.setFileName(attachment.getName());
                result.setContentType(attachment.getContentType());
                result.setComment(attachment.getComment());
                return this.resetUpdateStatusForResource(uri).thenCompose(reset -> CompletableFuture.completedFuture(result));
            }
            ConfluenceService.Model.Attachment result = (ConfluenceService.Model.Attachment)att.get();
            result.setContentType(attachment.getContentType());
            result.setComment(attachment.getComment());
            return CompletableFuture.completedFuture(result);
        })).thenCompose(finalAttachment -> this.canProceedToUpdateResource(uri).thenCompose(updated -> {
            if (updated.booleanValue()) {
                return this.updateAttachmentData(confluence, site, uri, confluencePage, (ConfluenceService.Model.Attachment)finalAttachment);
            }
            this.getLog().info((CharSequence)String.format("attachment [%s] has not been updated (deploy skipped)", this.getPrintableStringForResource(uri)));
            return CompletableFuture.completedFuture(finalAttachment);
        }));
    }

    protected void generateChildren(ConfluenceService confluence, Site site, Site.Page parentPage, ConfluenceService.Model.Page confluenceParentPage, Map<String, ConfluenceService.Model.Page> varsToParentPageMap) {
        this.getLog().debug((CharSequence)String.format("generateChildren # [%d]", parentPage.getChildren().size()));
        this.generateAttachments(confluence, site, parentPage, confluenceParentPage);
        for (Site.Page child : parentPage.getChildren()) {
            ConfluenceService.Model.Page confluencePage = this.generateChild(confluence, site, child, confluenceParentPage);
            for (Site.Page.Generated generated : child.getGenerateds()) {
                varsToParentPageMap.put(generated.getRef(), confluencePage);
            }
            if (confluencePage == null) continue;
            this.generateChildren(confluence, site, child, confluencePage, varsToParentPageMap);
        }
    }

    protected boolean navigateAttachments(File folder, Site.Page page) {
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    if (f.isDirectory() || f.isHidden()) continue;
                    Site.Attachment a = new Site.Attachment();
                    a.setName(f.getName());
                    a.setUri(f.toURI());
                    page.getAttachments().add(a);
                }
            }
            return true;
        }
        return false;
    }

    protected void navigateChild(final int level, File folder, final Site.Page parentChild) {
        if (folder.exists() && folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        if (AbstractConfluenceDeployMojo.this.navigateAttachments(file, parentChild)) {
                            return false;
                        }
                        Site.Page child = new Site.Page();
                        child.setName(file.getName());
                        AbstractConfluenceDeployMojo.this.setPageUriFormFile(child, new File(file, AbstractConfluenceDeployMojo.this.templateWiki.getName()));
                        parentChild.getChildren().add(child);
                        AbstractConfluenceDeployMojo.this.navigateChild(level + 1, file, child);
                        return true;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceDeployMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceDeployMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceDeployMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceDeployMojo.this.setPageUriFormFile(child, file);
                    parentChild.getChildren().add(child);
                    return false;
                }
            });
        }
    }

    public Site createSiteFromFolder() {
        final Site result = new Site();
        result.getLabels().addAll(this.getLabels());
        Site.Home home = new Site.Home();
        home.setName(this.getPageTitle());
        this.setPageUriFormFile((Site.Page)home, this.templateWiki);
        result.setHome(home);
        this.navigateAttachments(this.getAttachmentFolder(), (Site.Page)home);
        if (this.getChildrenFolder().exists() && this.getChildrenFolder().isDirectory()) {
            this.getChildrenFolder().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isHidden() || file.getName().charAt(0) == '.') {
                        return false;
                    }
                    if (file.isDirectory()) {
                        Site.Page parentChild = new Site.Page();
                        parentChild.setName(file.getName());
                        AbstractConfluenceDeployMojo.this.setPageUriFormFile(parentChild, new File(file, AbstractConfluenceDeployMojo.this.templateWiki.getName()));
                        result.getHome().getChildren().add(parentChild);
                        AbstractConfluenceDeployMojo.this.navigateChild(1, file, parentChild);
                        return false;
                    }
                    String fileName = file.getName();
                    if (!file.isFile() || !file.canRead() || !fileName.endsWith(AbstractConfluenceDeployMojo.this.getFileExt()) || fileName.equals(AbstractConfluenceDeployMojo.this.templateWiki.getName())) {
                        return false;
                    }
                    Site.Page child = new Site.Page();
                    int extensionLen = AbstractConfluenceDeployMojo.this.getFileExt().length();
                    child.setName(fileName.substring(0, fileName.length() - extensionLen));
                    AbstractConfluenceDeployMojo.this.setPageUriFormFile(child, file);
                    result.getHome().getChildren().add(child);
                    return false;
                }
            });
        }
        return result;
    }
}

