/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.confluence.plugin;

import java.util.List;
import java.util.Optional;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.maven.confluence.plugin.AbstractBaseConfluenceSiteMojo;

@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceSiteMojo {
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;

    private ConfluenceService.Model.PageSummary getStartPage(ConfluenceService confluence, ConfluenceService.Model.Page parentPage) throws Exception {
        String startPageTitle;
        if (this.isSiteDescriptorValid()) {
            Site site = this.createSiteFromModel();
            startPageTitle = site.getHome().getName();
        } else {
            startPageTitle = this.getPageTitle();
        }
        return confluence.findPageByTitle(parentPage.getId(), startPageTitle);
    }

    private void deletePage(ConfluenceService confluence) throws Exception {
        ConfluenceService.Model.Page parentPage = this.loadParentPage(confluence, Optional.empty());
        if (parentPage == null) {
            this.getLog().warn((CharSequence)"Parent page not found!");
            return;
        }
        ConfluenceService.Model.PageSummary start = this.getStartPage(confluence, parentPage);
        if (start == null) {
            this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", parentPage.getTitle(), this.getPageTitle(), parentPage.getSpace()));
            return;
        }
        if (this.recursive) {
            List descendents = confluence.getDescendents(start.getId());
            if (descendents == null || descendents.isEmpty()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", parentPage.getTitle(), this.getPageTitle(), parentPage.getSpace()));
            } else {
                for (ConfluenceService.Model.PageSummary descendent : descendents) {
                    this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s]  has been removed!", parentPage.getTitle(), this.getPageTitle(), descendent.getTitle()));
                    confluence.removePage(descendent.getId());
                }
            }
        }
        confluence.removePage(start.getId());
        this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), this.getPageTitle(), parentPage.getSpace()));
    }

    void tryDeletePage(ConfluenceService confluence) {
        try {
            this.deletePage(confluence);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.loadUserInfoFromSettings();
        super.confluenceExecute(this::tryDeletePage);
    }
}

