/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.json.JsonObjectBuilder;
import org.bsc.confluence.ConfluenceProxy;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.confluence.ExportFormat;
import org.bsc.confluence.rest.RESTConfluenceServiceImpl;
import org.bsc.confluence.rest.model.Page;
import org.bsc.confluence.rest.scrollversions.ScrollVersionsConfiguration;
import org.bsc.confluence.rest.scrollversions.ScrollVersionsRESTConfluenceService;
import org.bsc.confluence.xmlrpc.XMLRPCConfluenceServiceImpl;
import org.bsc.ssl.SSLCertificateInfo;

public class ConfluenceServiceFactory {
    public static ConfluenceService createInstance(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
        return ConfluenceServiceFactory.createInstance(endpoint, credentials, proxyInfo, sslInfo, Optional.empty());
    }

    public static ConfluenceService createInstance(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo, Optional<ScrollVersionsConfiguration> sv) throws Exception {
        if (ConfluenceService.Protocol.XMLRPC.match(endpoint)) {
            return new MixedConfluenceService(endpoint, credentials, proxyInfo, sslInfo);
        }
        if (ConfluenceService.Protocol.REST.match(endpoint)) {
            return sv.map(config -> new ScrollVersionsRESTConfluenceService(endpoint, config.getVersion(), credentials, sslInfo)).orElseGet(() -> new RESTConfluenceServiceImpl(endpoint, credentials, sslInfo));
        }
        throw new IllegalArgumentException(String.format("endpoint doesn't contain a valid API protocol\nIt must be '%s' or '%s'", ConfluenceService.Protocol.XMLRPC.path(), ConfluenceService.Protocol.REST.path()));
    }

    private static class MixedConfluenceService
    implements ConfluenceService {
        final XMLRPCConfluenceServiceImpl xmlrpcService;
        final RESTConfluenceServiceImpl restService;

        public MixedConfluenceService(String endpoint, ConfluenceService.Credentials credentials, ConfluenceProxy proxyInfo, SSLCertificateInfo sslInfo) throws Exception {
            this.xmlrpcService = XMLRPCConfluenceServiceImpl.createInstanceDetectingVersion((String)endpoint, (ConfluenceService.Credentials)credentials, (ConfluenceProxy)proxyInfo, (SSLCertificateInfo)sslInfo);
            String restEndpoint = ConfluenceService.Protocol.XMLRPC.removeFrom(endpoint) + ConfluenceService.Protocol.REST.path();
            this.restService = new RESTConfluenceServiceImpl(restEndpoint, credentials, sslInfo);
        }

        public ConfluenceService.Credentials getCredentials() {
            return this.xmlrpcService.getCredentials();
        }

        public ConfluenceService.Model.PageSummary findPageByTitle(String parentPageId, String title) throws Exception {
            return this.xmlrpcService.findPageByTitle(parentPageId, title);
        }

        public CompletableFuture<Boolean> removePage(ConfluenceService.Model.Page parentPage, String title) {
            return this.xmlrpcService.removePage(parentPage, title);
        }

        public CompletableFuture<ConfluenceService.Model.Page> createPage(ConfluenceService.Model.Page parentPage, String title) {
            return this.xmlrpcService.createPage(parentPage, title);
        }

        public CompletableFuture<ConfluenceService.Model.Attachment> addAttachment(ConfluenceService.Model.Page page, ConfluenceService.Model.Attachment attachment, InputStream source) {
            return this.xmlrpcService.addAttachment(page, attachment, source);
        }

        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page) {
            return this.xmlrpcService.storePage(page);
        }

        public CompletableFuture<ConfluenceService.Model.Page> storePage(ConfluenceService.Model.Page page, ConfluenceService.Storage content) {
            if (ConfluenceService.Storage.Representation.STORAGE == content.rapresentation) {
                if (page.getId() == null) {
                    JsonObjectBuilder inputData = this.restService.jsonForCreatingPage(page.getSpace(), page.getParentId(), page.getTitle());
                    this.restService.jsonAddBody(inputData, content);
                    return CompletableFuture.supplyAsync(() -> (ConfluenceService.Model.Page)this.restService.createPage(inputData.build()).map(Page::new).get());
                }
                return this.restService.storePage(page, content);
            }
            return this.xmlrpcService.storePage(page, content);
        }

        public boolean addLabelByName(String label, long id) throws Exception {
            return this.xmlrpcService.addLabelByName(ConfluenceUtils.sanitizeLabel((String)label), id);
        }

        public ConfluenceService.Model.Attachment createAttachment() {
            return this.xmlrpcService.createAttachment();
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Attachment>> getAttachment(String pageId, String name, String version) {
            return this.xmlrpcService.getAttachment(pageId, name, version);
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String spaceKey, String pageTitle) {
            return this.xmlrpcService.getPage(spaceKey, pageTitle);
        }

        public CompletableFuture<Optional<ConfluenceService.Model.Page>> getPage(String pageId) {
            return this.xmlrpcService.getPage(pageId);
        }

        public String toString() {
            return this.xmlrpcService.toString();
        }

        public List<ConfluenceService.Model.PageSummary> getDescendents(String pageId) throws Exception {
            return this.xmlrpcService.getDescendents(pageId);
        }

        public CompletableFuture<Boolean> removePageAsync(String pageId) {
            return this.xmlrpcService.removePageAsync(pageId);
        }

        public void exportPage(String url, String spaceKey, String pageTitle, ExportFormat exfmt, File outputFile) throws Exception {
            this.xmlrpcService.exportPage(url, spaceKey, pageTitle, exfmt, outputFile);
        }

        public void close() throws IOException {
            this.xmlrpcService.logout();
        }
    }
}

