/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.reporting.plugin;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.generator.Generator;
import org.apache.maven.tools.plugin.generator.GeneratorException;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.reporting.plugin.ConfluenceWikiWriter;
import org.codehaus.plexus.util.StringUtils;

public abstract class PluginConfluenceDocGenerator
implements Generator {
    public static final String DEFAULT_PLUGIN_TEMPLATE_WIKI = "defaultPluginTemplate.confluence";

    public void execute(File destinationDirectory, PluginDescriptor pluginDescriptor) throws IOException {
        throw new UnsupportedOperationException("execute is not supported!");
    }

    public void execute(File destinationDirectory, PluginToolsRequest request) throws GeneratorException {
        throw new UnsupportedOperationException("execute is not supported!");
    }

    protected void writeSummary(Writer writer, PluginDescriptor pluginDescriptor) {
        try (ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);){
            w.printBiggerHeading("Description");
            Optional.ofNullable(pluginDescriptor.getDescription()).ifPresent(description -> w.println((String)description));
            w.printNewParagraph();
        }
    }

    protected List<Goal> writeGoalsAsChildren(Writer writer, String parentName, List<MojoDescriptor> mojos) {
        ArrayList<Goal> result = new ArrayList<Goal>(mojos.size());
        try (ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);){
            w.printBiggestHeading("Plugin Goals");
            w.println("|| Name || Description ||");
            for (MojoDescriptor descriptor : mojos) {
                Goal goal = new Goal(descriptor);
                w.print('|');
                w.printf("[%s|%s]", goal.descriptor.getFullGoalName(), goal.getPageName(parentName));
                w.print('|');
                w.print(ConfluenceUtils.decode((String)goal.descriptor.getDescription()));
                w.println('|');
                result.add(goal);
            }
            w.printNewParagraph();
        }
        return result;
    }

    private void writeGoals(Writer writer, List<MojoDescriptor> mojos) {
        ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);
        w.printBiggerHeading("Plugin Goals");
        for (MojoDescriptor descriptor : mojos) {
            w.appendBullet().printLinkToAnchor(descriptor.getGoal(), descriptor.getFullGoalName());
        }
        w.printNewParagraph();
        for (MojoDescriptor descriptor : mojos) {
            Goal goal = new Goal(descriptor);
            goal.write(w);
        }
    }

    private List<Parameter> filterParameters(List<Parameter> parameterList) {
        ArrayList<Parameter> filtered = new ArrayList<Parameter>();
        if (parameterList != null) {
            for (Parameter parameter : parameterList) {
                String expression;
                if (!parameter.isEditable() || (expression = parameter.getExpression()) != null && expression.startsWith("${component.")) continue;
                filtered.add(parameter);
            }
        }
        return filtered;
    }

    private void writeParameterDetails(List<Parameter> parameterList, ConfluenceWikiWriter w) {
        w.printNormalHeading("Parameter Details");
        w.printNewParagraph();
        for (Parameter parameter : parameterList) {
            w.printSmallHeading(ConfluenceWikiWriter.createAnchor(parameter.getName(), parameter.getName()));
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No Description.";
            }
            w.println(ConfluenceUtils.decode((String)description));
            this.writeDetail("Deprecated", parameter.getDeprecated(), w);
            this.writeDetail("Type", parameter.getType(), w);
            this.writeDetail("Since", parameter.getSince(), w);
            if (parameter.isRequired()) {
                this.writeDetail("Required", "Yes", w);
            } else {
                this.writeDetail("Required", "No", w);
            }
            this.writeDetail("Expression", parameter.getExpression(), w);
            this.writeDetail("Default", parameter.getDefaultValue(), w);
        }
    }

    private void writeDetail(String param, String value, ConfluenceWikiWriter w) {
        if (StringUtils.isNotEmpty((String)value)) {
            w.printf("||%s|%s|\n", ConfluenceUtils.decode((String)param), ConfluenceUtils.decode((String)value));
        }
    }

    private void writeParameterSummary(List<Parameter> parameterList, ConfluenceWikiWriter w) {
        List<Parameter> optionalParams;
        List<Parameter> requiredParams = this.getParametersByRequired(true, parameterList);
        if (!requiredParams.isEmpty()) {
            this.writeParameterList("Required Parameters", requiredParams, w);
        }
        if (!(optionalParams = this.getParametersByRequired(false, parameterList)).isEmpty()) {
            this.writeParameterList("Optional Parameters", optionalParams, w);
        }
    }

    private void writeParameterList(String title, List<Parameter> parameterList, ConfluenceWikiWriter w) {
        w.printNormalHeading(title);
        w.printNewParagraph();
        w.printf("||%s||%s||%s||\n", "Name", "Type", "Description");
        for (Parameter parameter : parameterList) {
            int index = parameter.getType().lastIndexOf(".");
            w.print('|');
            w.print(ConfluenceWikiWriter.createLinkToAnchor(parameter.getName(), parameter.getName()));
            w.print('|');
            w.print(parameter.getType().substring(index + 1));
            w.print('|');
            String description = parameter.getDescription();
            if (StringUtils.isEmpty((String)description)) {
                description = "No description.";
            }
            if (StringUtils.isNotEmpty((String)parameter.getDeprecated())) {
                description = "Deprecated. " + description;
            }
            w.print(ConfluenceUtils.decode((String)description).replace("\n\n", "\n"));
            if (StringUtils.isNotEmpty((String)parameter.getDefaultValue())) {
                w.printf(" Default value is %s", ConfluenceUtils.decode((String)parameter.getDefaultValue()));
            }
            w.println('|');
        }
    }

    private List<Parameter> getParametersByRequired(boolean required, List<Parameter> parameterList) {
        if (parameterList == null) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter parameter : parameterList) {
            if (parameter.isRequired() != required) continue;
            list.add(parameter);
        }
        return list;
    }

    public class Goal {
        public final MojoDescriptor descriptor;

        public Goal(MojoDescriptor mojoDescriptor) {
            this.descriptor = mojoDescriptor;
        }

        public void write(ConfluenceWikiWriter w) {
            w.appendBigHeading().appendAnchor(this.descriptor.getGoal(), this.descriptor.getFullGoalName()).println();
            String description = this.descriptor.getDescription() != null ? ConfluenceUtils.decode((String)this.descriptor.getDescription()) : "No description.";
            w.printQuote(description);
            w.printNewParagraph();
            this.writeAttributes(w);
            w.printNewParagraph();
            this.writeParameterTable(w);
        }

        public String getPageName(String parentName) {
            String goalName = String.format("%s - %s", parentName, this.descriptor.getGoal());
            return goalName;
        }

        public ConfluenceService.Model.Page generatePage(ConfluenceService confluence, ConfluenceService.Model.Page parent, String parentName) throws Exception {
            String goalName = this.getPageName(parentName);
            CompletionStage result = confluence.getOrCreatePage(parent.getSpace(), parent.getTitle(), goalName).thenCompose(page -> {
                StringWriter writer = new StringWriter(102400);
                ConfluenceWikiWriter w = new ConfluenceWikiWriter(writer);
                this.write(w);
                writer.flush();
                return confluence.storePage(page, new ConfluenceService.Storage(writer.toString(), ConfluenceService.Storage.Representation.WIKI));
            });
            return (ConfluenceService.Model.Page)((CompletableFuture)result).get();
        }

        private void writeAttributes(ConfluenceWikiWriter w) {
            w.printNormalHeading("Mojo Attributes");
            String value = this.descriptor.getDeprecated();
            if (StringUtils.isNotEmpty((String)value)) {
                w.printBullet("This plugin goal has been deprecated: " + value);
            }
            if (this.descriptor.isProjectRequired()) {
                w.printBullet("Requires a Maven 2.0 project to execute.");
            }
            if (this.descriptor.isAggregator()) {
                w.printBullet("Executes as an aggregator plugin.");
            }
            if (this.descriptor.isDirectInvocationOnly()) {
                w.printBullet("Executes by direct invocation only.");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getDependencyResolutionRequired()))) {
                w.printBullet("Requires dependency resolution of artifacts in scope: {{" + value + "}}");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getSince()))) {
                w.printBullet("Since version: {{" + value + "}}");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getPhase()))) {
                w.printBullet("Automatically executes within the lifecycle phase: {{" + value + "}}");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getExecutePhase()))) {
                w.printBullet("Invokes the execution of the lifecycle phase {{" + value + "}} prior to executing itself.");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getExecuteGoal()))) {
                w.printBullet("Invokes the execution of this plugin's goal {{" + value + "}} prior to executing itself.");
            }
            if (StringUtils.isNotEmpty((String)(value = this.descriptor.getExecuteLifecycle()))) {
                w.printBullet("Executes in its own lifecycle: {{" + value + "}}");
            }
            if (this.descriptor.isOnlineRequired()) {
                w.printBullet("Requires that mvn runs in online mode.");
            }
            if (!this.descriptor.isInheritedByDefault()) {
                w.printBullet("Is NOT inherited by default in multi-project builds.");
            }
        }

        private void writeParameterTable(ConfluenceWikiWriter w) {
            List parameterList = this.descriptor.getParameters();
            List list = PluginConfluenceDocGenerator.this.filterParameters(parameterList);
            if (list != null && list.size() > 0) {
                PluginConfluenceDocGenerator.this.writeParameterSummary(list, w);
                PluginConfluenceDocGenerator.this.writeParameterDetails(list, w);
            }
        }
    }
}

