/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.reporting.renderer;

import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Organization;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;

public class ProjectSummaryRenderer
extends AbstractMavenReportRenderer {
    private MavenProject project;
    private I18N i18n;
    private Locale locale;

    public ProjectSummaryRenderer(Sink sink, MavenProject project, I18N i18n, Locale locale) {
        super(sink);
        this.project = project;
        this.i18n = i18n;
        this.locale = locale;
    }

    public String getTitle() {
        return "Project Summary";
    }

    protected void renderBody() {
        String homepage;
        String description;
        this.startSection(this.getTitle());
        String name = this.project.getName();
        if (name == null) {
            name = "";
        }
        if ((description = this.project.getDescription()) == null) {
            description = "";
        }
        if ((homepage = this.project.getUrl()) == null) {
            homepage = "";
        }
        this.startSection(this.getReportString("report.summary.general.title"));
        this.startTable();
        this.tableHeader(new String[]{this.getReportString("report.summary.field"), this.getReportString("report.summary.value")});
        this.tableRow(new String[]{this.getReportString("report.summary.general.name"), name});
        this.tableRow(new String[]{this.getReportString("report.summary.general.description"), description});
        this.tableRowWithLink(new String[]{this.getReportString("report.summary.general.homepage"), homepage});
        this.endTable();
        this.endSection();
        this.startSection(this.getReportString("report.summary.organization.title"));
        Organization organization = this.project.getOrganization();
        if (organization == null) {
            this.paragraph(this.getReportString("report.summary.noorganization"));
        } else {
            if (organization.getName() == null) {
                organization.setName("");
            }
            if (organization.getUrl() == null) {
                organization.setUrl("");
            }
            this.startTable();
            this.tableHeader(new String[]{this.getReportString("report.summary.field"), this.getReportString("report.summary.value")});
            this.tableRow(new String[]{this.getReportString("report.summary.organization.name"), organization.getName()});
            this.tableRowWithLink(new String[]{this.getReportString("report.summary.organization.url"), organization.getUrl()});
            this.endTable();
        }
        this.endSection();
        this.startSection(this.getReportString("report.summary.build.title"));
        this.startTable();
        this.tableHeader(new String[]{this.getReportString("report.summary.field"), this.getReportString("report.summary.value")});
        this.tableRow(new String[]{this.getReportString("report.summary.build.groupid"), this.project.getGroupId()});
        this.tableRow(new String[]{this.getReportString("report.summary.build.artifactid"), this.project.getArtifactId()});
        this.tableRow(new String[]{this.getReportString("report.summary.build.version"), this.project.getVersion()});
        this.tableRow(new String[]{this.getReportString("report.summary.build.type"), this.project.getPackaging()});
        this.endTable();
        this.endSection();
        this.endSection();
    }

    private String getReportString(String key) {
        return this.i18n.getString("project-info-report", this.locale, key);
    }

    private void tableRowWithLink(String[] content) {
        this.sink.tableRow();
        for (int ctr = 0; ctr < content.length; ++ctr) {
            String cell = content[ctr];
            if (cell == null) {
                cell = "";
            }
            this.sink.tableCell();
            if (ctr == content.length - 1 && cell.length() > 0) {
                this.sink.link(cell);
                this.sink.text(cell);
                this.sink.link_();
            } else {
                this.sink.text(cell);
            }
            this.sink.tableCell_();
        }
        this.sink.tableRow_();
    }
}

