/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.model.Site;
import org.bsc.mojo.AbstractBaseConfluenceSiteMojo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceSiteMojo {
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;

    private boolean deletePage(ConfluenceService confluence) {
        Optional<String> optStartPageTitle = Optional.empty();
        if (this.isSiteDescriptorValid()) {
            Site site = this.createSiteFromModel(this.getSiteModelVariables());
            optStartPageTitle = Optional.ofNullable(site.getHome().getName());
        }
        if (!optStartPageTitle.isPresent()) {
            optStartPageTitle = Optional.ofNullable(this.getPageTitle());
        }
        return optStartPageTitle.map(startPageTitle -> this.deletePage(confluence, (String)startPageTitle)).orElseGet(() -> {
            this.getLog().warn((CharSequence)"page title has not been provided!");
            return false;
        });
    }

    private boolean deletePage(ConfluenceService confluence, String startPageTitle) {
        this.getLog().debug((CharSequence)String.format("start deleting from page [%s]", startPageTitle));
        return (Boolean)((CompletableFuture)((CompletableFuture)this.loadParentPage(confluence, Optional.empty()).thenCompose(parentPage -> confluence.getPageByTitle(parentPage.getId(), startPageTitle).thenCompose(start -> {
            if (!start.isPresent()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                return CompletableFuture.completedFuture(false);
            }
            if (this.recursive) {
                ((CompletableFuture)confluence.getDescendents(((ConfluenceService.Model.PageSummary)start.get()).getId()).thenAccept(descendents -> {
                    if (descendents == null || descendents.isEmpty()) {
                        this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                    } else {
                        for (ConfluenceService.Model.PageSummary descendent : descendents) {
                            boolean removed = (Boolean)((CompletableFuture)confluence.removePage(descendent.getId()).exceptionally(ex -> {
                                this.getLog().warn((CharSequence)String.format("cannot remove descendent %s", descendent.getTitle()), ex);
                                return false;
                            })).join();
                            if (removed) {
                                this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), startPageTitle, descendent.getTitle(), parentPage.getSpace()));
                                continue;
                            }
                            this.getLog().warn((CharSequence)String.format("Page [%s]/[%s]/[%s] in [%s] has not been removed!", parentPage.getTitle(), startPageTitle, descendent.getTitle(), parentPage.getSpace()));
                        }
                    }
                })).join();
            }
            return confluence.removePage(((ConfluenceService.Model.PageSummary)start.get()).getId()).thenApply(success -> {
                if (success.booleanValue()) {
                    this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                } else {
                    this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not been removed!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                }
                return success;
            });
        }))).exceptionally(ex -> {
            this.getLog().warn((CharSequence)ex.getMessage());
            return false;
        })).join();
    }

    @Override
    public void execute(ConfluenceService confluence) throws Exception {
        this.deletePage(confluence);
    }
}

