/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import biz.source_code.miniTemplator.MiniTemplator;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.confluence.model.Site;
import org.bsc.confluence.model.SiteFactory;
import org.bsc.mojo.AbstractBaseConfluenceMojo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AbstractBaseConfluenceSiteMojo
extends AbstractBaseConfluenceMojo
implements SiteFactory.Model {
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/src/site/confluence/attachments")
    private File attachmentFolder;
    @Parameter(defaultValue="${basedir}/src/site/confluence/children")
    private File childrenFolder;
    @Parameter(alias="title", property="confluence.page", defaultValue="${project.build.finalName}")
    private String pageTitle;
    @Parameter(defaultValue="${basedir}/src/site/confluence/site.xml")
    protected File siteDescriptor;

    public File getSiteDescriptor() {
        return this.siteDescriptor;
    }

    protected boolean isSiteDescriptorValid() {
        return this.siteDescriptor != null && this.siteDescriptor.exists() && this.siteDescriptor.isFile();
    }

    protected File getChildrenFolder() {
        return this.childrenFolder;
    }

    protected File getAttachmentFolder() {
        return this.attachmentFolder;
    }

    protected final String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String title) {
        this.pageTitle = title;
    }

    public void addStdProperties(MiniTemplator t) {
        Map<String, String> props = this.getProperties();
        if (props == null || props.isEmpty()) {
            this.getLog().info((CharSequence)"no properties set!");
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                try {
                    t.setVariable(e.getKey(), e.getValue(), true);
                }
                catch (MiniTemplator.VariableNotDefinedException e1) {
                    this.getLog().debug((CharSequence)String.format("variable %s not defined in template", e.getKey()));
                }
            }
        }
    }

    protected Map<String, Object> getSiteModelVariables() {
        return Collections.singletonMap("project", this.project);
    }

    public Site createSiteFromModel(Map<String, Object> variables) {
        if (!this.isSiteDescriptorValid()) {
            this.getLog().warn((CharSequence)"siteDescriptor is missing!");
            return null;
        }
        try {
            return this.createFrom(this.siteDescriptor, variables);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"error creating site from model!", (Throwable)ex);
            return null;
        }
    }
}

