/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.ConfluenceUtils;
import org.bsc.confluence.rest.MultipartFormDataBodyPublisher;
import org.bsc.confluence.rest.model.Attachment;
import org.bsc.confluence.rest.model.IdHelper;

public abstract class AbstractRESTConfluenceService
implements IdHelper {
    private static final String EXPAND = "space,version,container";
    protected HttpClient client;

    public abstract ConfluenceService.Credentials getCredentials();

    protected abstract URI urlBuilder() throws URISyntaxException;

    public CompletableFuture<HttpResponse<String>> fromRequestAsync(HttpRequest.Builder reqBuilder) {
        HttpRequest req = reqBuilder.build();
        return this.client.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(res -> {
            int statusCode = res.statusCode();
            if (statusCode >= 300) {
                throw new ServiceException(String.format("error: %s\n%s\n%s", req.uri(), res, res.body()), (HttpResponse<String>)res);
            }
            return res;
        });
    }

    protected void fromRequest(HttpRequest.Builder reqBuilder, String description, Consumer<HttpResponse<String>> consumer) {
        try {
            HttpResponse<String> res = this.client.send(reqBuilder.build(), HttpResponse.BodyHandlers.ofString());
            int statusCode = res.statusCode();
            if (statusCode >= 300) {
                throw new ServiceException(String.format("error: %s\n%s\n%s", description, res, res.body()), res);
            }
            consumer.accept(res);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Stream<JsonObject> mapToStream(HttpResponse<String> res) {
        String body = res.body();
        try (StringReader r = new StringReader(body);){
            Stream<JsonObject> stream;
            block17: {
                JsonReader rdr = Json.createReader((Reader)r);
                try {
                    JsonObject root = rdr.readObject();
                    Stream.Builder<JsonObject> stream2 = Stream.builder();
                    if (root.containsKey((Object)"results")) {
                        JsonArray results = root.getJsonArray("results");
                        if (results != null) {
                            for (int ii = 0; ii < results.size(); ++ii) {
                                stream2.add(results.getJsonObject(ii));
                            }
                        }
                    } else {
                        stream2.add(root);
                    }
                    stream = stream2.build();
                    if (rdr == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rdr != null) {
                        try {
                            rdr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rdr.close();
            }
            return stream;
        }
        catch (IOException | JsonParsingException e) {
            throw new Error(e);
        }
    }

    protected JsonObject mapToObject(HttpResponse<String> res) {
        JsonObject jsonObject;
        String body = res.body();
        StringReader r = new StringReader(body);
        try {
            JsonReader rdr = Json.createReader((Reader)r);
            jsonObject = rdr.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new Error(ex);
            }
        }
        ((Reader)r).close();
        return jsonObject;
    }

    public static URI buildUrl(URI url, List<String> path, Map<String, String> query) throws URISyntaxException {
        String previousQuery;
        String previousPath;
        String newPath = previousPath = url.getPath();
        if (!path.isEmpty()) {
            newPath = String.join((CharSequence)"/", path);
            if (previousPath != null) {
                newPath = String.format("%s/%s", previousPath, newPath);
            }
        }
        String newQuery = previousQuery = url.getQuery();
        if (!query.isEmpty()) {
            newQuery = query.entrySet().stream().map(kv -> String.format("%s=%s", kv.getKey(), kv.getValue())).collect(Collectors.joining("&"));
            if (previousQuery != null) {
                newQuery = String.format("%s&%s", previousQuery, newQuery);
            }
        }
        return new URI(url.getScheme(), url.getUserInfo(), url.getHost(), url.getPort(), newPath, newQuery, url.getFragment());
    }

    private URI buildUrl(List<String> path, Map<String, String> query) {
        try {
            return AbstractRESTConfluenceService.buildUrl(this.urlBuilder(), path, query);
        }
        catch (URISyntaxException ex) {
            throw new Error(ex);
        }
    }

    protected CompletableFuture<Optional<JsonObject>> findPageById(String id) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        URI url = this.buildUrl(List.of("content", id), Map.of("expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "find page", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).findFirst()));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> findPages(String spaceKey, String title) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        URI url = this.buildUrl(List.of("content"), Map.of("spaceKey", spaceKey, "title", title, "expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "find pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> descendantPages(long id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        URI url = this.buildUrl(List.of("content", String.valueOf(id), "child", "page"), Map.of("expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "get descendant pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).flatMap(o -> {
            long childId = IdHelper.getId(o);
            return Stream.concat(Stream.of(o), this.descendantPages(childId).join().stream());
        }).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> childrenPages(String id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        URI url = this.buildUrl(List.of("content", id, "child", "page"), Map.of("expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "get children pages", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    public CompletableFuture<Optional<JsonObject>> findPage(String spaceKey, String title) {
        return this.findPages(spaceKey, title).thenApply(list -> list.stream().findFirst());
    }

    protected CompletableFuture<Boolean> deletePageById(String id) {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        URI url = this.buildUrl(List.of("content", id), Collections.emptyMap());
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).DELETE();
        this.fromRequest(req, "delete page", res -> result.complete(true));
        return result;
    }

    public final CompletableFuture<Optional<JsonObject>> createPage(JsonObject inputData) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        HttpRequest.BodyPublisher inputBody = HttpRequest.BodyPublishers.ofString(inputData.toString(), StandardCharsets.UTF_8);
        URI url = this.buildUrl(List.of("content"), Collections.emptyMap());
        HttpRequest.Builder req = HttpRequest.newBuilder().header("Content-Type", "application/json").uri(url).POST(inputBody);
        this.fromRequest(req, "create page", res -> result.complete(Stream.of(res).map(this::mapToObject).findFirst()));
        return result;
    }

    protected CompletableFuture<Optional<JsonObject>> updatePage(String pageId, JsonObject inputData) {
        CompletableFuture<Optional<JsonObject>> result = new CompletableFuture<Optional<JsonObject>>();
        HttpRequest.BodyPublisher inputBody = HttpRequest.BodyPublishers.ofString(inputData.toString(), StandardCharsets.UTF_8);
        URI url = this.buildUrl(List.of("content", pageId), Collections.emptyMap());
        HttpRequest.Builder req = HttpRequest.newBuilder().header("X-Atlassian-Token", "nocheck").header("Content-Type", "application/json").uri(url).PUT(inputBody);
        this.fromRequest(req, "update page", res -> result.complete(Stream.of(res).map(this::mapToObject).findFirst()));
        return result;
    }

    protected final CompletableFuture<Void> addLabels(String id, String ... labels) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        JsonArrayBuilder inputBuilder = Json.createArrayBuilder();
        for (String name : labels) {
            inputBuilder.add(Json.createObjectBuilder().add("prefix", "global").add("name", ConfluenceUtils.sanitizeLabel((String)name)));
        }
        JsonArray inputData = inputBuilder.build();
        HttpRequest.BodyPublisher inputBody = HttpRequest.BodyPublishers.ofString(inputData.toString(), StandardCharsets.UTF_8);
        URI url = this.buildUrl(List.of("content", id, "label"), Collections.emptyMap());
        HttpRequest.Builder req = HttpRequest.newBuilder().header("Content-Type", "application/json").uri(url).POST(inputBody);
        this.fromRequest(req, "add label", res -> result.complete(null));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> getAttachments(String id) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        URI url = this.buildUrl(List.of("content", id, "child", "attachment"), Map.of("expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "get attachments", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> getAttachment(String id, String fileName) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        URI url = this.buildUrl(List.of("content", id, "child", "attachment"), Map.of("filename", fileName, "expand", EXPAND));
        HttpRequest.Builder req = HttpRequest.newBuilder().uri(url).GET();
        this.fromRequest(req, "get attachment", res -> result.complete(Stream.of(res).flatMap(this::mapToStream).collect(Collectors.toList())));
        return result;
    }

    protected CompletableFuture<List<JsonObject>> addAttachment(String id, Attachment att, InputStream data) {
        CompletableFuture<List<JsonObject>> result = new CompletableFuture<List<JsonObject>>();
        MultipartFormDataBodyPublisher bodyPublisher = new MultipartFormDataBodyPublisher().add("comment", att.getComment()).add("minorEdit", "true").addStream("file", att.getFileName(), () -> data, att.getContentType());
        List<String> path = att.getId() != null ? List.of("content", id, "child", "attachment", att.getId(), "data") : List.of("content", id, "child", "attachment");
        URI url = this.buildUrl(path, Collections.emptyMap());
        HttpRequest.Builder req = HttpRequest.newBuilder().header("X-Atlassian-Token", "nocheck").headers("Content-Type", bodyPublisher.contentType()).uri(url).POST(bodyPublisher);
        this.fromRequest(req, "create page", res -> result.complete(Stream.of(res).flatMap(post -> att.getId() != null ? Stream.of(this.mapToObject((HttpResponse<String>)post)) : this.mapToStream((HttpResponse<String>)post)).collect(Collectors.toList())));
        return result;
    }

    public static class ServiceException
    extends Error {
        public final HttpResponse<String> res;

        public ServiceException(String message, HttpResponse<String> res) {
            super(message);
            this.res = res;
        }
    }
}

