/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.reporting.renderer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.bsc.reporting.renderer.CalculateRuleForSinceTagName;
import org.bsc.reporting.renderer.GitLogUtil;
import org.bsc.reporting.renderer.VersionUtil;
import org.eclipse.jgit.lib.Repository;

public class GitLogJiraIssuesRenderer
extends AbstractMavenReportRenderer {
    private final Log log;
    private String gitLogSinceTagName;
    private final String gitLogUntilTagName;
    private final CalculateRuleForSinceTagName calculateRuleForSinceTagName;
    private final String currentVersion;
    private final String gitLogTagNamesPattern;
    private final List<String> jiraProjectKeyList;
    private final Boolean gitLogGroupByVersions;
    private final URL gitLogJiraInstanceBaseUrl;

    public GitLogJiraIssuesRenderer(Sink sink, String gitLogSinceTagName, String gitLogUntilTagName, List<String> jiraProjectKeyList, String currentVersion, CalculateRuleForSinceTagName calculateRuleForSinceTagName, String gitLogTagNamesPattern, Boolean gitLogGroupByVersions, URL gitLogJiraInstanceBaseUrl, Log log) {
        super(sink);
        this.gitLogSinceTagName = gitLogSinceTagName;
        this.gitLogUntilTagName = gitLogUntilTagName;
        this.currentVersion = currentVersion;
        this.calculateRuleForSinceTagName = calculateRuleForSinceTagName;
        this.jiraProjectKeyList = jiraProjectKeyList;
        this.gitLogTagNamesPattern = gitLogTagNamesPattern;
        this.gitLogGroupByVersions = gitLogGroupByVersions;
        this.gitLogJiraInstanceBaseUrl = gitLogJiraInstanceBaseUrl;
        this.log = log;
    }

    public String formatJiraIssuesToString(Collection<String> jiraIssues) {
        StringBuilder output = new StringBuilder(100);
        for (String jiraIssueKey : jiraIssues) {
            output.append("{jira:").append(jiraIssueKey);
            if (this.gitLogJiraInstanceBaseUrl != null) {
                output.append("|url=").append(this.gitLogJiraInstanceBaseUrl).append("/browse/").append(jiraIssueKey);
            }
            output.append("}\\\\\n");
        }
        return output.toString();
    }

    private String formatJiraIssuesByVersionToString(LinkedHashMap<String, Set<String>> map) {
        StringBuilder output = new StringBuilder(100);
        ListIterator<String> iter = new ArrayList<String>(map.keySet()).listIterator(map.size());
        while (iter.hasPrevious()) {
            String version = iter.previous();
            output.append(this.formatJiraIssuesToString((Collection<String>)map.get(version)));
            boolean hasIssues = map.get(version).isEmpty();
            if (!iter.hasPrevious()) continue;
            if (!hasIssues) {
                output.append(" \\\\ ");
            }
            output.append(version).append(" \\\\ ");
        }
        return output.toString();
    }

    public String getTitle() {
        return "";
    }

    protected void renderBody() {
        Repository repository = null;
        try {
            this.log.debug((CharSequence)"Try to open git repository.");
            repository = GitLogUtil.openRepository();
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("cannot open git repository  with error " + e));
        }
        this.log.debug((CharSequence)"Try to open load version tag list.");
        Set<String> versionTagList = GitLogUtil.loadVersionTagList(repository, this.gitLogTagNamesPattern);
        if (!CalculateRuleForSinceTagName.NO_RULE.equals((Object)this.calculateRuleForSinceTagName)) {
            this.log.info((CharSequence)String.format("Try to calculate tag name part by currentVersion %s and rule %s", new Object[]{this.currentVersion, this.calculateRuleForSinceTagName}));
            this.overrideGitLogSinceTagNameIfNeeded(versionTagList);
            this.log.info((CharSequence)("Override gitLogSinceTagName by nearest version tag name found: " + this.gitLogSinceTagName));
        }
        if (this.gitLogSinceTagName == null || this.gitLogSinceTagName.isEmpty()) {
            this.log.warn((CharSequence)"gitLogSinceTagName is not specified and cannot be calculated via calculateRuleForSinceTagName");
        }
        String pattern = "([A-Za-z]+)-\\d+";
        if (this.jiraProjectKeyList != null && !this.jiraProjectKeyList.isEmpty()) {
            pattern = this.craetePatternFromJiraProjectKeyList();
        }
        String report = "";
        if (this.gitLogGroupByVersions.booleanValue()) {
            LinkedHashMap<String, Set<String>> jiraIssuesByVersion = null;
            try {
                LinkedList<String> linkedList = VersionUtil.sortAndFilter(versionTagList, this.gitLogSinceTagName, this.gitLogUntilTagName);
                jiraIssuesByVersion = GitLogUtil.extractJiraIssuesByVersion(repository, linkedList, pattern);
            }
            catch (Exception e) {
                this.log.error((CharSequence)("cannot extractJiraIssues with error " + e), (Throwable)e);
            }
            if (jiraIssuesByVersion != null) {
                this.log.info((CharSequence)String.format("Found %d version tags", jiraIssuesByVersion.keySet().size()));
                this.log.debug((CharSequence)(": " + jiraIssuesByVersion));
                report = this.formatJiraIssuesByVersionToString(jiraIssuesByVersion);
            } else {
                report = "NO_JIRA_ISSUES_BY_VERSION_FOUND";
            }
        } else {
            Set<String> jiraIssues = null;
            try {
                jiraIssues = GitLogUtil.extractJiraIssues(repository, this.gitLogSinceTagName, this.gitLogUntilTagName, pattern);
            }
            catch (Exception e) {
                this.log.error((CharSequence)("cannot extractJiraIssues with error " + e), (Throwable)e);
            }
            this.log.info((CharSequence)String.format("Found %d JIRA issues", jiraIssues.size()));
            this.log.debug((CharSequence)(": " + jiraIssues));
            report = this.formatJiraIssuesToString(jiraIssues);
        }
        this.sink.rawText(report);
    }

    private String craetePatternFromJiraProjectKeyList() {
        String patternKeys = "";
        for (String pkey : this.jiraProjectKeyList) {
            patternKeys = patternKeys + pkey + "|";
        }
        patternKeys = patternKeys.substring(0, patternKeys.length() - 1);
        String pattern = "(" + patternKeys + ")-\\d+";
        return pattern;
    }

    protected void overrideGitLogSinceTagNameIfNeeded(Collection<String> versionTagList) {
        String tagNamePart = VersionUtil.calculateVersionTagNamePart(this.currentVersion, this.calculateRuleForSinceTagName);
        this.log.info((CharSequence)String.format("Calculated tag name part is %s", tagNamePart));
        versionTagList = VersionUtil.removeTagWithVersion(versionTagList, this.currentVersion);
        if (!this.calculateRuleForSinceTagName.equals((Object)CalculateRuleForSinceTagName.LATEST_RELEASE_VERSION)) {
            versionTagList = VersionUtil.removeTagWithVersion(versionTagList, tagNamePart);
        }
        this.gitLogSinceTagName = VersionUtil.findNearestVersionTagsBefore(versionTagList, tagNamePart).orElse(null);
    }

    public String getGitLogSinceTagName() {
        return this.gitLogSinceTagName;
    }
}

